/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualObject;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.common.api.checks.SecondaryLocation;

@Rule(key="S6382")
public class CertificateBasedAuthenticationCheck
extends AbstractArmResourceCheck {
    private static final String CLIENT_CERTIFICATE_ENABLED_PROPERTY = "clientCertEnabled";
    private static final String MISSING_CERTIFICATE_MESSAGE = "Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.";
    private static final String DISABLED_CERTIFICATE_MESSAGE = "Make sure that disabling certificate-based authentication is safe here.";
    private static final String ALLOWING_NO_CERTIFICATE_MESSAGE = "Connections without client certificates will be permitted. Make sure it is safe here.";
    private static final String PASSWORD_USE_MESSAGE = "This authentication method is not certificate-based. Make sure it is safe here.";
    private static final String NO_CERTIFICATE_LIST_MESSAGE = "Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.";
    private static final String EMPTY_CERTIFICATE_LIST_MESSAGE = "Omitting a list of certificates disables certificate-based authentication. Make sure it is safe here.";
    private static final String WRONG_AUTHENTICATION_METHOD_MESSAGE = "This authentication method is not certificate-based. Make sure it is safe here.";
    private static final Set<String> SENSITIVE_LINKED_SERVICES_TYPE = Set.of("Web", "HttpServer");
    private static final Set<String> SENSITIVE_PIPELINES_TYPE = Set.of("WebActivity", "WebHook");
    private static final Set<String> SENSITIVE_PIPELINES_AUTHENTICATION_TYPE = Set.of("Basic", "ServicePrincipal");

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.ApiManagement/service/gateways/hostnameConfigurations", (ContextualResource resource) -> ((ContextualProperty)resource.property("negotiateClientCertificate").reportIf(CheckUtils.isFalse(), DISABLED_CERTIFICATE_MESSAGE, new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("Microsoft.App/containerApps", CertificateBasedAuthenticationCheck::checkContainerApps);
        this.register("Microsoft.ContainerRegistry/registries/tokens", CertificateBasedAuthenticationCheck::checkRegistriesTokens);
        this.register("Microsoft.DataFactory/factories/linkedservices", CertificateBasedAuthenticationCheck::checkLinkedServices);
        this.register("Microsoft.DocumentDB/cassandraClusters", CertificateBasedAuthenticationCheck::checkCassandraClusters);
        this.register("Microsoft.Scheduler/jobCollections/jobs", CertificateBasedAuthenticationCheck::checkJobCollections);
        this.register("Microsoft.ServiceFabric/clusters", CertificateBasedAuthenticationCheck::checkServiceFabric);
        this.register("Microsoft.Web/sites", CertificateBasedAuthenticationCheck::checkWebSites);
        this.register("Microsoft.Web/sites/slots", CertificateBasedAuthenticationCheck::checkWebSitesSlots);
        this.register("Microsoft.DataFactory/factories/pipelines", CertificateBasedAuthenticationCheck::checkPipelines);
        this.register("Microsoft.Network/applicationGateways", CertificateBasedAuthenticationCheck::checkApplicationGateways);
        this.register(List.of("Microsoft.SignalRService/signalR", "Microsoft.SignalRService/webPubSub"), CertificateBasedAuthenticationCheck::checkSignalRService);
    }

    private static void checkContainerApps(ContextualResource resource) {
        ContextualObject ingress;
        if (CertificateBasedAuthenticationCheck.isResourceVersionEqualsOrAfter(resource, "2022-10-01") && (ingress = resource.object("configuration").object("ingress")).isPresent()) {
            ((ContextualProperty)((ContextualProperty)ingress.property("clientCertificateMode").reportIf(CheckUtils.isValue("accept"::equals), ALLOWING_NO_CERTIFICATE_MESSAGE, new SecondaryLocation[0])).reportIf(CheckUtils.isValue("ignore"::equals), DISABLED_CERTIFICATE_MESSAGE, new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.", new SecondaryLocation[0]);
        }
    }

    private static void checkRegistriesTokens(ContextualResource resource) {
        ContextualObject credentials = resource.object("credentials");
        if (credentials.isPresent()) {
            ((ContextualProperty)credentials.property("certificates").reportIf(CheckUtils.isEmptyArray(), EMPTY_CERTIFICATE_LIST_MESSAGE, new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.", new SecondaryLocation[0]);
            credentials.property("passwords").reportIf(CheckUtils.isArrayWithValues(), "This authentication method is not certificate-based. Make sure it is safe here.", new SecondaryLocation[0]);
        }
    }

    private static void checkLinkedServices(ContextualResource resource) {
        ContextualProperty type = resource.property("type");
        ContextualProperty authenticationType = resource.object("typeProperties").property("authenticationType");
        if (type.is(CheckUtils.isValue(SENSITIVE_LINKED_SERVICES_TYPE::contains)) && authenticationType.is(CheckUtils.isValue(str -> !"ClientCertificate".equals(str)))) {
            authenticationType.report("This authentication method is not certificate-based. Make sure it is safe here.", type.toSecondary("Service type"));
        }
    }

    private static void checkCassandraClusters(ContextualResource resource) {
        ((ContextualProperty)resource.property("clientCertificates").reportIf(CheckUtils.isEmptyArray(), EMPTY_CERTIFICATE_LIST_MESSAGE, new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.", new SecondaryLocation[0]);
    }

    private static void checkApplicationGateways(ContextualResource resource) {
        ((ContextualProperty)resource.property("trustedRootCertificates").reportIf(CheckUtils.isEmptyArray(), EMPTY_CERTIFICATE_LIST_MESSAGE, new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.", new SecondaryLocation[0]);
    }

    private static void checkJobCollections(ContextualResource resource) {
        CertificateBasedAuthenticationCheck.checkRequestAuthenticationType(resource.object("action"));
        CertificateBasedAuthenticationCheck.checkRequestAuthenticationType(resource.object("action").object("errorAction"));
    }

    private static void checkRequestAuthenticationType(ContextualObject action) {
        action.object("request").object("authentication").property("type").reportIf(CheckUtils.isValue(str -> !"ClientCertificate".equals(str)), "This authentication method is not certificate-based. Make sure it is safe here.", new SecondaryLocation[0]);
    }

    private static void checkServiceFabric(ContextualResource resource) {
        ContextualProperty clientCertificateCommonNames = resource.property("clientCertificateCommonNames");
        ContextualProperty clientCertificateThumbprints = resource.property("clientCertificateThumbprints");
        if (clientCertificateCommonNames.isAbsent() && clientCertificateThumbprints.isAbsent()) {
            resource.report(String.format("Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.", "clientCertificateCommonNames/clientCertificateThumbprints"), new SecondaryLocation[0]);
        } else {
            boolean isThumbprintsCertProvided;
            boolean isCommonNamesCertProvided = clientCertificateCommonNames.isPresent() && clientCertificateCommonNames.is(CheckUtils.isArrayWithValues());
            boolean bl = isThumbprintsCertProvided = clientCertificateThumbprints.isPresent() && clientCertificateThumbprints.is(CheckUtils.isArrayWithValues());
            if (!isCommonNamesCertProvided && !isThumbprintsCertProvided) {
                ArrayList<SecondaryLocation> secondaries = new ArrayList<SecondaryLocation>();
                clientCertificateCommonNames.ifPresent(tree -> secondaries.add(clientCertificateCommonNames.toSecondary("Empty certificate list")));
                clientCertificateThumbprints.ifPresent(tree -> secondaries.add(clientCertificateThumbprints.toSecondary("Empty certificate list")));
                resource.report(EMPTY_CERTIFICATE_LIST_MESSAGE, secondaries);
            }
        }
    }

    private static void checkWebSites(ContextualResource resource) {
        ((ContextualProperty)resource.property(CLIENT_CERTIFICATE_ENABLED_PROPERTY).reportIf(CheckUtils.isFalse(), DISABLED_CERTIFICATE_MESSAGE, new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.", new SecondaryLocation[0]);
        ((ContextualProperty)resource.property("clientCertMode").reportIf(CheckUtils.isValue(str -> !"Required".equals(str)), ALLOWING_NO_CERTIFICATE_MESSAGE, new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.", new SecondaryLocation[0]);
    }

    private static void checkWebSitesSlots(ContextualResource resource) {
        resource.property(CLIENT_CERTIFICATE_ENABLED_PROPERTY).reportIf(CheckUtils.isFalse(), DISABLED_CERTIFICATE_MESSAGE, new SecondaryLocation[0]);
        resource.property("clientCertMode").reportIf(CheckUtils.isValue(str -> !"Required".equals(str)), ALLOWING_NO_CERTIFICATE_MESSAGE, new SecondaryLocation[0]);
    }

    private static void checkPipelines(ContextualResource resource) {
        resource.list("activities").objects().forEach(activity -> {
            ContextualProperty type = activity.property("type");
            ContextualProperty authenticationType = activity.object("typeProperties").property("authenticationType");
            if (type.is(CheckUtils.isValue(SENSITIVE_PIPELINES_TYPE::contains))) {
                if (authenticationType.is(CheckUtils.isValue(SENSITIVE_PIPELINES_AUTHENTICATION_TYPE::contains))) {
                    authenticationType.report("This authentication method is not certificate-based. Make sure it is safe here.", type.toSecondary("Pipeline type"));
                }
            }
        });
    }

    private static void checkSignalRService(ContextualResource resource) {
        ((ContextualProperty)resource.object("tls").property(CLIENT_CERTIFICATE_ENABLED_PROPERTY).reportIf(CheckUtils.isFalse(), DISABLED_CERTIFICATE_MESSAGE, new SecondaryLocation[0])).reportIfAbsent("Omitting \"%s\" disables certificate-based authentication. Make sure it is safe here.", new SecondaryLocation[0]);
    }

    private static boolean isResourceVersionEqualsOrAfter(ContextualResource resource, String version) {
        return resource.version.compareTo(version) >= 0;
    }
}

