/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.IacSensor;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.common.warnings.AnalysisWarningsWrapper;
import org.sonar.iac.common.warnings.DefaultAnalysisWarningsWrapper;
import org.sonar.iac.terraform.checks.TerraformCheckList;
import org.sonar.iac.terraform.parser.HclParser;
import org.sonar.iac.terraform.plugin.TerraformLanguage;
import org.sonar.iac.terraform.plugin.TerraformProviders;
import org.sonar.iac.terraform.reports.tflint.TFLintImporter;
import org.sonar.iac.terraform.visitors.TerraformChecksVisitor;
import org.sonar.iac.terraform.visitors.TerraformHighlightingVisitor;
import org.sonar.iac.terraform.visitors.TerraformMetricsVisitor;
import org.sonarsource.analyzer.commons.ExternalReportProvider;

public class TerraformSensor
extends IacSensor {
    private final Checks<IacCheck> checks;
    private final TerraformProviders providerVersions;
    private final AnalysisWarningsWrapper analysisWarnings;

    public TerraformSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, TerraformLanguage language, TerraformProviders providerVersions) {
        this(sonarRuntime, fileLinesContextFactory, checkFactory, noSonarFilter, language, providerVersions, DefaultAnalysisWarningsWrapper.NOOP_ANALYSIS_WARNINGS);
    }

    public TerraformSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, TerraformLanguage language, TerraformProviders providerVersions, AnalysisWarningsWrapper analysisWarnings) {
        super(sonarRuntime, fileLinesContextFactory, noSonarFilter, (Language)language);
        this.checks = checkFactory.create("terraform");
        this.checks.addAnnotatedChecks(TerraformCheckList.checks());
        this.providerVersions = providerVersions;
        this.analysisWarnings = analysisWarnings;
    }

    protected HclParser treeParser() {
        return new HclParser();
    }

    @Override
    protected String repositoryKey() {
        return "terraform";
    }

    @Override
    protected void importExternalReports(SensorContext sensorContext) {
        ExternalReportProvider.getReportFiles(sensorContext, "sonar.terraform.tflint.reportPaths").forEach(report -> new TFLintImporter(sensorContext, this.analysisWarnings).importReport((File)report));
    }

    @Override
    protected List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        ArrayList<TreeVisitor<InputFileContext>> visitors = new ArrayList<TreeVisitor<InputFileContext>>();
        if (this.isNotSonarLintContext(sensorContext)) {
            visitors.add(new TerraformMetricsVisitor(this.fileLinesContextFactory, this.noSonarFilter));
            visitors.add(new TerraformHighlightingVisitor());
        }
        visitors.add(new TerraformChecksVisitor(this.checks, statistics, this.providerVersions));
        return visitors;
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.terraform.activate";
    }
}

