/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.yaml.TreePredicates;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.kubernetes.checks.AbstractKubernetesObjectCheck;

@Rule(key="S5849")
public class CapabilitiesCheck
extends AbstractKubernetesObjectCheck {
    private static final String MESSAGE = "Make sure setting capabilities is safe here.";

    @Override
    void registerObjectCheck() {
        this.register("Pod", (BlockObject pod) -> pod.blocks("containers").forEach(container -> container.block("securityContext").block("capabilities").list("add").reportIfAnyItem(TreePredicates.isSet(), MESSAGE)));
        this.register(List.of("DaemonSet", "Deployment", "Job", "ReplicaSet", "ReplicationController", "StatefulSet"), (BlockObject obj) -> obj.block("template").block("spec").blocks("containers").forEach(container -> container.block("securityContext").block("capabilities").list("add").reportIfAnyItem(TreePredicates.isSet(), MESSAGE)));
    }
}

