/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.parser.grammar;

import com.sonar.sslr.api.GenericTokenType;
import java.util.Arrays;
import org.sonar.iac.common.parser.grammar.Punctuator;
import org.sonar.iac.docker.parser.grammar.DockerKeyword;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;

public enum DockerLexicalGrammar implements GrammarRuleKey
{
    FILE,
    BODY,
    DOCKERIMAGE,
    STRING_LITERAL,
    EQUALS_OPERATOR,
    EOF,
    WHITESPACE,
    SKIPPED_WHITESPACE,
    WHITESPACE_OR_LINE_BREAK,
    SPACING,
    EOL,
    INSTRUCTION,
    ONBUILD,
    FROM,
    MAINTAINER,
    STOPSIGNAL,
    WORKDIR,
    EXPOSE,
    LABEL,
    ENV,
    ARG,
    CMD,
    ENTRYPOINT,
    RUN,
    ADD,
    COPY,
    USER,
    VOLUME,
    SHELL,
    HEALTHCHECK,
    HEALTHCHECK_NONE,
    ARGUMENTS,
    FLAG,
    FLAG_PREFIX,
    FLAG_NAME,
    EXEC_FORM,
    SHELL_FORM,
    SHELL_FORM_GENERIC,
    HEREDOC_FORM,
    HEREDOC_FORM_CONTENT,
    ALIAS,
    ALIAS_AS,
    IMAGE_ALIAS,
    HEREDOC_EXPRESSION,
    QUOTED_STRING_LITERAL,
    UNQUOTED_STRING_LITERAL,
    UNQUOTED_KEY_LITERAL,
    HEREDOC_NAME,
    ARGUMENT,
    ARGUMENT_GENERIC,
    REGULAR_STRING_LITERAL,
    EXPANDABLE_STRING_LITERAL,
    EXPANDABLE_STRING_LITERAL_GENERIC,
    STRING_WITH_ENCAPS_VAR_CHARACTERS,
    UNQUOTED_VARIABLE_MODIFIER,
    REGULAR_VAR_IDENTIFIER,
    REGULAR_VARIABLE,
    ENCAPSULATED_VARIABLE,
    ENCAPSULATED_VARIABLE_GENERIC,
    ENCAPS_VAR_MODIFIER_SEPARATOR,
    ENCAPS_VAR_MODIFIER_GENERIC,
    KEY_VALUE_PAIR;


    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        DockerLexicalGrammar.lexical(b);
        DockerLexicalGrammar.punctuators(b);
        DockerLexicalGrammar.keywords(b);
        return b;
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        b.rule(Punctuator.EQU).is(Punctuator.EQU.getValue()).skip();
        b.rule(Punctuator.COMMA).is(b.optional(SKIPPED_WHITESPACE), Punctuator.COMMA.getValue()).skip();
        b.rule(Punctuator.RBRACKET).is(b.optional(SKIPPED_WHITESPACE), Punctuator.RBRACKET.getValue()).skip();
        b.rule(Punctuator.LBRACKET).is(SKIPPED_WHITESPACE, Punctuator.LBRACKET.getValue()).skip();
        b.rule(Punctuator.DOUBLE_QUOTE).is(Punctuator.DOUBLE_QUOTE.getValue());
        b.rule(Punctuator.DOLLAR).is(Punctuator.DOLLAR.getValue()).skip();
        b.rule(Punctuator.DOLLAR_LCURLY).is(Punctuator.DOLLAR_LCURLY.getValue());
        b.rule(Punctuator.RCURLYBRACE).is(Punctuator.RCURLYBRACE.getValue());
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule(WHITESPACE).is(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++")).skip();
        b.rule(SKIPPED_WHITESPACE).is(b.skippedTrivia(WHITESPACE));
        b.rule(WHITESPACE_OR_LINE_BREAK).is(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}\\n\\r\\u2028\\u2029]++")).skip();
        b.rule(EOL).is(b.regexp("(?:(?:\\r\\n|[\\n\\r\\u2028\\u2029])|$)"));
        b.rule(SPACING).is(b.oneOrMore(b.firstOf(b.commentTrivia(b.regexp("(?:#(?:[^\\n\\r])*+)")), b.skippedTrivia(WHITESPACE_OR_LINE_BREAK)))).skip();
        b.rule(EOF).is(b.token(GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule(REGULAR_VAR_IDENTIFIER).is(b.regexp("[a-zA-Z_0-9]++"));
        b.rule(ENCAPS_VAR_MODIFIER_SEPARATOR).is(b.regexp(":(-|\\+)"));
        b.rule(ENCAPS_VAR_MODIFIER_GENERIC).is(b.regexp("(\\\\}|[^}])+"));
        b.rule(QUOTED_STRING_LITERAL).is(b.regexp("(?:\"(?:(?:(?:[^\"\\\\$]|(?<!$)\\{)|(?:\\$(?!\\{|[a-zA-Z_0-9]))|(?:\\\\[\\s\\S]?))++)?+\"|'(?:[^'\\\\]*+(?:\\\\[\\s\\S])?+)*+')"));
        b.rule(UNQUOTED_STRING_LITERAL).is(b.regexp("(?:(?:\\\\$|\\\\'|\\\\\"|[^\\s'\"\\$]|\\$(?![a-zA-Z_0-9{]))++)"));
        b.rule(UNQUOTED_KEY_LITERAL).is(b.regexp("(?:(?:\\\\$|\\\\'|\\\\\"|[^\\s'\"$=])++)"));
        b.rule(HEREDOC_NAME).is(b.regexp("<<-?\"?([a-zA-Z0-9_]++)\"?"));
        b.rule(STRING_WITH_ENCAPS_VAR_CHARACTERS).is(b.regexp("(?:(?:(?:[^\"\\\\$]|(?<!$)\\{)|(?:\\$(?!\\{|[a-zA-Z_0-9]))|(?:\\\\[\\s\\S]?))++)"));
        b.rule(UNQUOTED_VARIABLE_MODIFIER).is(b.regexp("(?:(?:\\\\$|\\\\'|\\\\\"|[^\\s'\"$}])++(?<!}))"));
        b.rule(STRING_LITERAL).is(SKIPPED_WHITESPACE, b.regexp("(?:(?:\"(?:[^\"\\\\]*+(?:\\\\[\\s\\S])?+)*+\")|(?:(?:(?!(?:\\\\[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+(?:\\r\\n|[\\n\\r\\u2028\\u2029])))[^\\s])++))+"));
        b.rule(EQUALS_OPERATOR).is(b.regexp("="));
        b.rule(IMAGE_ALIAS).is(SKIPPED_WHITESPACE, b.regexp("[-a-zA-Z0-9_\\.]+"));
        b.rule(FLAG_PREFIX).is(SKIPPED_WHITESPACE, b.regexp("--"));
        b.rule(FLAG_NAME).is(b.regexp("[a-z][-a-z]*+"));
        b.rule(ALIAS_AS).is(SKIPPED_WHITESPACE, b.regexp("(?i)AS"));
        b.rule(HEALTHCHECK_NONE).is(SKIPPED_WHITESPACE, b.regexp("(?i)NONE"));
        b.rule(HEREDOC_EXPRESSION).is(SKIPPED_WHITESPACE, b.regexp("(?:<<-?\"?([a-zA-Z0-9_]++)\"?\\s+)+[\\s\\S]*?([\\n\\r])\\1(?=[\\n\\r]|$)"));
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        Arrays.stream(DockerKeyword.values()).forEach(tokenType -> b.rule((GrammarRuleKey)tokenType).is(b.optional(SPACING), b.regexp("(?i)" + tokenType.getValue())).skip());
    }
}

