/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import org.sonar.api.utils.Version;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.plugin.TerraformProviders;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6383")
public class RoleBasedAccessControlCheck
extends AbstractNewResourceCheck {
    private static final String MISSING_MESSAGE = "Omitting '%s' disables role-based access control for this resource. Make sure it is safe here.";
    private static final String DISABLED_MESSAGE = "Make sure that disabling role-based access control is safe here.";
    private static final Version AZURE_V_3 = Version.create((int)3, (int)0);

    @Override
    protected void registerResourceConsumer() {
        this.register("azurerm_kubernetes_cluster", (ResourceSymbol resource) -> {
            AttributeSymbol rbacEnabled;
            BlockSymbol rbac = resource.block("role_based_access_control");
            if (resource.provider(TerraformProviders.Provider.Identifier.AZURE).hasVersionLowerThan(AZURE_V_3)) {
                rbac.reportIfAbsent(MISSING_MESSAGE, new SecondaryLocation[0]);
            }
            if (!(rbacEnabled = (AttributeSymbol)rbac.attribute("enabled").reportIf(ExpressionPredicate.isFalse(), DISABLED_MESSAGE, new SecondaryLocation[0])).is(ExpressionPredicate.isFalse())) {
                RoleBasedAccessControlCheck.checkActiveDirectoryRoleBasedAccessControl(rbac.block("azure_active_directory"));
            }
            RoleBasedAccessControlCheck.checkActiveDirectoryRoleBasedAccessControl(resource.block("azure_active_directory_role_based_access_control"));
            resource.attribute("role_based_access_control_enabled").reportIf(ExpressionPredicate.isFalse(), DISABLED_MESSAGE, new SecondaryLocation[0]);
        });
        this.register("azurerm_key_vault", (ResourceSymbol resource) -> ((AttributeSymbol)resource.attribute("enable_rbac_authorization").reportIf(ExpressionPredicate.isFalse(), DISABLED_MESSAGE, new SecondaryLocation[0])).reportIfAbsent(MISSING_MESSAGE, new SecondaryLocation[0]));
    }

    private static void checkActiveDirectoryRoleBasedAccessControl(BlockSymbol adRbac) {
        AttributeSymbol adRbacEnabled;
        AttributeSymbol activeDirectoryManaged = adRbac.attribute("managed");
        if (activeDirectoryManaged.is(ExpressionPredicate.isTrue()) && (adRbacEnabled = (AttributeSymbol)adRbac.attribute("azure_rbac_enabled").reportIf(ExpressionPredicate.isFalse(), DISABLED_MESSAGE, new SecondaryLocation[0])).isAbsent()) {
            activeDirectoryManaged.report(String.format(MISSING_MESSAGE, "azure_rbac_enabled"), new SecondaryLocation[0]);
        }
    }
}

