/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.reports.hadolint;

import java.util.Map;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.iac.docker.reports.hadolint.ReportFormat;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;

public class ReportFormatJson
implements ReportFormat {
    private static final Map<String, String> severityMapping = Map.of("error", "CRITICAL", "warning", "MAJOR", "info", "MINOR", "style", "INFO");

    @Override
    public String getPath(JSONObject issueJson) {
        return (String)issueJson.get("file");
    }

    @Override
    public String getRuleId(JSONObject issueJson) {
        return (String)issueJson.get("code");
    }

    @Override
    public String getMessage(JSONObject issueJson) {
        return (String)issueJson.get("message");
    }

    @Override
    public NewIssueLocation getIssueLocation(JSONObject issueJson, NewExternalIssue externalIssue, InputFile inputFile) {
        return externalIssue.newLocation().message(this.getMessage(issueJson)).on((InputComponent)inputFile).at(inputFile.selectLine(this.asInt(issueJson.get("line"))));
    }

    @Override
    public String getRuleType(JSONObject issueJson) {
        return "CRITICAL".equals(this.getSeverity(issueJson)) ? "BUG" : "CODE_SMELL";
    }

    @Override
    public String getSeverity(JSONObject issueJson) {
        String level = (String)issueJson.get("level");
        return severityMapping.getOrDefault(level, "INFO");
    }
}

