/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils.command;

import java.util.function.Predicate;
import org.sonar.iac.docker.checks.utils.command.CommandPredicate;
import org.sonar.iac.docker.checks.utils.command.MultipleUnorderedOptionsPredicate;
import org.sonar.iac.docker.checks.utils.command.PredicateContext;
import org.sonar.iac.docker.symbols.ArgumentResolution;

public class SingularPredicate
implements CommandPredicate {
    final Predicate<String> predicate;
    final CommandPredicate.Type type;

    public SingularPredicate(Predicate<String> predicate, CommandPredicate.Type type) {
        this.predicate = predicate;
        this.type = type;
    }

    public static SingularPredicate equalMatch(String string) {
        return new SingularPredicate(string::equals, CommandPredicate.Type.MATCH);
    }

    @Override
    public boolean hasType(CommandPredicate.Type ... types) {
        for (CommandPredicate.Type t : types) {
            if (!this.type.equals((Object)t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void match(PredicateContext context) {
        ArgumentResolution resolution = context.getNextArgumentToHandleAndRemoveFromList();
        if (resolution.isUnresolved()) {
            context.setStatus(PredicateContext.Status.ABORT);
            return;
        }
        if (this.predicate.test(resolution.value())) {
            if (this.hasType(CommandPredicate.Type.NO_MATCH)) {
                context.setStatus(PredicateContext.Status.ABORT);
                return;
            }
            if (this.hasType(CommandPredicate.Type.ZERO_OR_MORE) && !(context.getCurrentPredicate() instanceof MultipleUnorderedOptionsPredicate)) {
                context.detectCurrentPredicateAgain();
            }
            context.addAsArgumentToReport(resolution);
        } else if (this.hasType(CommandPredicate.Type.OPTIONAL, CommandPredicate.Type.ZERO_OR_MORE, CommandPredicate.Type.NO_MATCH)) {
            context.argumentShouldBeMatchedAgain(resolution);
        } else {
            context.setStatus(PredicateContext.Status.FOUND_NO_PREDICATE_MATCH);
            return;
        }
        context.setStatus(PredicateContext.Status.CONTINUE);
    }
}

