/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.checks.utils.CheckUtils;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6437")
public class SecretsGenerationCheck
implements IacCheck {
    private static final String MESSAGE = "Change this code not to store a secret in the image.";
    private static final Set<String> SSH_KEYGEN_COMPLIANT_FLAGS = Set.of("-l", "-F", "-H", "-R", "-r", "-k", "-Q");
    private static final CommandDetector SSH_DETECTOR = CommandDetector.builder().with("ssh-keygen").withOptionalRepeatingExcept(SSH_KEYGEN_COMPLIANT_FLAGS).notWith(SSH_KEYGEN_COMPLIANT_FLAGS::contains).build();
    private static final Set<String> SENSITIVE_KEYTOOL_FLAGS = Set.of("-gencert", "-genkeypair", "-genseckey", "-genkey");
    private static final CommandDetector KEYTOOL_DETECTOR = CommandDetector.builder().with("keytool").withAnyOptionExcluding(SENSITIVE_KEYTOOL_FLAGS).with(SENSITIVE_KEYTOOL_FLAGS).withAnyOptionExcluding(SENSITIVE_KEYTOOL_FLAGS).build();
    private static final Set<String> SENSITIVE_OPENSSL_SUBCOMMANDS = Set.of("req", "genrsa", "rsa", "gendsa", "ec", "ecparam", "x509", "genpkey", "pkey");
    private static final CommandDetector SENSITIVE_OPENSSL_COMMANDS = CommandDetector.builder().with("openssl").with(SENSITIVE_OPENSSL_SUBCOMMANDS).withAnyOptionExcluding(Collections.emptyList()).build();
    private static final Set<CommandDetector> DETECTORS = Set.of(SSH_DETECTOR, KEYTOOL_DETECTOR, SENSITIVE_OPENSSL_COMMANDS);

    @Override
    public void initialize(InitContext init) {
        init.register(RunInstruction.class, SecretsGenerationCheck::checkRunInstruction);
    }

    private static void checkRunInstruction(CheckContext ctx, RunInstruction runInstruction) {
        List<ArgumentResolution> resolvedArgument = CheckUtils.resolveInstructionArguments(runInstruction);
        DETECTORS.forEach(detector -> detector.search(resolvedArgument).forEach(command -> ctx.reportIssue((HasTextRange)command, MESSAGE)));
    }
}

