/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.ArrayDeque;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.AddInstruction;
import org.sonar.iac.docker.tree.api.Argument;
import org.sonar.iac.docker.tree.api.CopyInstruction;
import org.sonar.iac.docker.tree.api.Flag;

@Rule(key="S6470")
public class DirectoryCopySourceCheck
implements IacCheck {
    private static final String MESSAGE_CURRENT_OR_ROOT = "%s recursively might inadvertently add sensitive data to the container. Make sure it is safe here.";
    private static final String MESSAGE_GLOBBING = "%s using a glob pattern might inadvertently add sensitive data to the container. Make sure it is safe here.";
    private static final Pattern WINDOWS_DRIVE_PATTERN = Pattern.compile("^[a-zA-Z]:$");

    @Override
    public void initialize(InitContext init) {
        init.register(AddInstruction.class, DirectoryCopySourceCheck::checkAdd);
        init.register(CopyInstruction.class, DirectoryCopySourceCheck::checkCopy);
    }

    private static void checkAdd(CheckContext ctx, AddInstruction add) {
        for (Argument src : add.srcs()) {
            ArgumentResolution resolution = ArgumentResolution.of(src);
            String path = resolution.value();
            if (!resolution.isResolved() || path == null || path.startsWith("http://") || path.startsWith("https://")) continue;
            DirectoryCopySourceCheck.reportIfSensitive(ctx, src, DirectoryCopySourceCheck.isSensitivePath(path), "Adding files");
        }
    }

    private static void checkCopy(CheckContext ctx, CopyInstruction copyInstruction) {
        if (DirectoryCopySourceCheck.hasFromOption(copyInstruction.options())) {
            return;
        }
        for (Argument src : copyInstruction.srcs()) {
            ArgumentResolution resolution = ArgumentResolution.of(src);
            String path = resolution.value();
            if (!resolution.isResolved() || path == null) continue;
            DirectoryCopySourceCheck.reportIfSensitive(ctx, src, DirectoryCopySourceCheck.isSensitivePath(path), "Copying");
        }
    }

    private static boolean hasFromOption(List<Flag> options) {
        return options.stream().anyMatch(param -> param.name().equals("from"));
    }

    private static void reportIfSensitive(CheckContext ctx, Argument src, PathSensitivity sensitivity, String messagePrefix) {
        if (sensitivity == PathSensitivity.ROOT_OR_CURRENT) {
            ctx.reportIssue(src, String.format(MESSAGE_CURRENT_OR_ROOT, messagePrefix));
        } else if (sensitivity == PathSensitivity.TOP_LEVEL_GLOBBING) {
            ctx.reportIssue(src, String.format(MESSAGE_GLOBBING, messagePrefix));
        }
    }

    private static PathSensitivity isSensitivePath(String path) {
        String[] levels = DirectoryCopySourceCheck.normalize(path);
        if (levels.length == 0) {
            return PathSensitivity.ROOT_OR_CURRENT;
        }
        if (levels.length == 1 && DirectoryCopySourceCheck.isRootOrCurrent(levels[0])) {
            return PathSensitivity.ROOT_OR_CURRENT;
        }
        int topLevel = DirectoryCopySourceCheck.getLevelToCheckIndex(levels);
        if (levels[topLevel].endsWith("*") && levels.length == topLevel + 1) {
            return PathSensitivity.TOP_LEVEL_GLOBBING;
        }
        return PathSensitivity.SAFE;
    }

    private static boolean isRootOrCurrent(String level) {
        return level.isEmpty() || ".".equals(level) || WINDOWS_DRIVE_PATTERN.matcher(level).find();
    }

    private static int getLevelToCheckIndex(String[] levels) {
        if (DirectoryCopySourceCheck.isRootOrCurrent(levels[0])) {
            return 1;
        }
        return 0;
    }

    static String[] normalize(String path) {
        ArrayDeque<String> levels = new ArrayDeque<String>();
        for (String current : path.split("/")) {
            if ("..".equals(current) && !levels.isEmpty()) {
                levels.removeLast();
                continue;
            }
            if (current.isEmpty()) {
                if (!levels.isEmpty()) continue;
                levels.add(current);
                continue;
            }
            if (".".equals(current) && levels.isEmpty()) {
                levels.add(current);
                continue;
            }
            if (".".equals(current)) continue;
            levels.add(current);
        }
        return levels.toArray(new String[0]);
    }

    private static enum PathSensitivity {
        SAFE,
        ROOT_OR_CURRENT,
        TOP_LEVEL_GLOBBING;

    }
}

