/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.Flag;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6502")
public class BuilderSandboxCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure that disabling the builder sandbox is safe here.";

    @Override
    public void initialize(InitContext init) {
        init.register(RunInstruction.class, (ctx, instruction) -> {
            for (Flag option : instruction.options()) {
                if (!"security".equals(option.name()) || !"insecure".equals(ArgumentResolution.of(option.value()).value())) continue;
                ctx.reportIssue(option, MESSAGE);
            }
        });
    }
}

