/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checkdsl;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checkdsl.ContextualTree;
import org.sonar.iac.common.checks.TextUtils;

public abstract class ContextualPropertyTree<S extends ContextualPropertyTree<S, T, E>, T extends PropertyTree & Tree, E extends Tree>
extends ContextualTree<S, T> {
    protected ContextualPropertyTree(CheckContext ctx, @Nullable T tree, @Nullable String name, @Nullable ContextualTree<? extends ContextualTree<?, ?>, ? extends Tree> parent) {
        super(ctx, tree, name, parent);
    }

    public S reportIf(Predicate<E> predicate, String message, SecondaryLocation ... secondaries) {
        if (this.tree != null && predicate.test(((PropertyTree)((Object)this.tree)).value())) {
            return (S)((ContextualPropertyTree)this.report(message, List.of(secondaries)));
        }
        return (S)this;
    }

    public boolean is(Predicate<E> predicate) {
        if (this.tree != null) {
            return predicate.test(((PropertyTree)((Object)this.tree)).value());
        }
        return predicate.test(null);
    }

    @CheckForNull
    public String asString() {
        return Optional.ofNullable((PropertyTree)((Object)this.tree)).flatMap(tree -> TextUtils.getValue(tree.value())).orElse(null);
    }
}

