/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.json;

import java.util.ArrayList;
import java.util.List;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.common.api.tree.Tree;

public class ResourceDeclarationImpl
extends AbstractArmTreeImpl
implements ResourceDeclaration {
    private final Identifier name;
    private final StringLiteral version;
    private final StringLiteral type;
    private final List<Property> properties;

    public ResourceDeclarationImpl(Identifier name, StringLiteral version, StringLiteral type, List<Property> properties) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.properties = properties;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        children.add(this.name);
        children.add(this.version);
        children.add(this.type);
        this.properties.forEach(property -> {
            children.add(property.key());
            children.add(property.value());
        });
        return children;
    }

    @Override
    public Identifier name() {
        return this.name;
    }

    @Override
    public StringLiteral version() {
        return this.version;
    }

    @Override
    public StringLiteral type() {
        return this.type;
    }

    @Override
    public List<Property> properties() {
        return this.properties;
    }

    @Override
    public ArmTree.Kind getKind() {
        return ArmTree.Kind.RESOURCE_DECLARATION;
    }
}

