/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.sonar.iac.arm.tree.api.ArrayExpression;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;

public class ArmTreeUtils {
    public static final String ARRAY_TOKEN = "*";

    private ArmTreeUtils() {
    }

    public static List<String> computePath(String path) {
        return Arrays.asList(path.split("/"));
    }

    public static List<Tree> resolveProperties(String path, Tree tree) {
        LinkedList<String> pathElements = new LinkedList<String>(Arrays.asList(path.split("/")));
        return ArmTreeUtils.resolveProperties(pathElements, tree);
    }

    public static List<Tree> resolveProperties(Queue<String> path, Tree tree) {
        while (!path.isEmpty() && tree != null) {
            String nextPath = path.poll();
            if (nextPath.equals(ARRAY_TOKEN)) {
                if (tree instanceof ArrayExpression) {
                    ArrayExpression array = (ArrayExpression)tree;
                    ArrayList<Tree> trees = new ArrayList<Tree>();
                    array.elements().forEach(element -> trees.addAll(ArmTreeUtils.resolveProperties(new LinkedList<String>(path), (Tree)element)));
                    return trees;
                }
                return Collections.emptyList();
            }
            tree = PropertyUtils.value(tree, nextPath).orElse(null);
        }
        return tree != null ? List.of(tree) : Collections.emptyList();
    }
}

