/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.plugin;

import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.iac.arm.checks.ArmCheckList;
import org.sonar.iac.arm.parser.ArmParser;
import org.sonar.iac.arm.plugin.ArmLanguage;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.FileIdentificationPredicate;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.yaml.YamlSensor;

public class ArmSensor
extends YamlSensor {
    public ArmSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, ArmLanguage language) {
        super(sonarRuntime, fileLinesContextFactory, checkFactory, noSonarFilter, (Language)language, ArmCheckList.checks());
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguages(new String[]{"json"}).name("IaC " + this.language.getName() + " Sensor");
    }

    @Override
    protected String repositoryKey() {
        return "azureresourcemanager";
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.arm.activate";
    }

    @Override
    protected FilePredicate customFilePredicate(SensorContext sensorContext) {
        return new FileIdentificationPredicate(sensorContext.config().get("sonar.arm.file.identifier").orElse(""));
    }

    @Override
    protected TreeParser<Tree> treeParser() {
        return new ArmParser();
    }
}

