/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.parser;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.arm.parser.ArmBaseConverter;
import org.sonar.iac.arm.tree.api.ArrayExpression;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.NumericLiteral;
import org.sonar.iac.arm.tree.api.ParameterDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.impl.json.ParameterDeclarationImpl;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.TupleTree;

public class ParameterDeclarationConverter
extends ArmBaseConverter {
    public ParameterDeclarationConverter(@Nullable InputFileContext inputFileContext) {
        super(inputFileContext);
    }

    public Stream<TupleTree> extractParametersSequence(MappingTree document) {
        return this.extractMappingToTupleTreeOnField(document, "parameters");
    }

    public ParameterDeclaration convertParameters(TupleTree tree) {
        Identifier identifier = this.toIdentifier(tree.key());
        StringLiteral type = this.toStringLiteralOrNull(tree.value(), "type");
        Expression defaultValue = this.toExpressionOrNull(tree, "defaultValue");
        NumericLiteral minValue = this.toNumericLiteralOrNull(tree.value(), "minValue");
        NumericLiteral maxValue = this.toNumericLiteralOrNull(tree.value(), "maxValue");
        NumericLiteral minLength = this.toNumericLiteralOrNull(tree.value(), "minLength");
        NumericLiteral maxLength = this.toNumericLiteralOrNull(tree.value(), "maxLength");
        ArrayExpression allowedValues = this.toArrayExpressionOrNull(tree.value(), "allowedValues");
        StringLiteral description = this.toNestedStringLiteralOrNull(tree.value(), "metadata", "description");
        return new ParameterDeclarationImpl(identifier, type, defaultValue, allowedValues, description, minValue, maxValue, minLength, maxLength);
    }
}

