/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.parser;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.arm.parser.ArmBaseConverter;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.OutputDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.impl.json.OutputDeclarationImpl;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.TupleTree;

public class OutputDeclarationConverter
extends ArmBaseConverter {
    public OutputDeclarationConverter(@Nullable InputFileContext inputFileContext) {
        super(inputFileContext);
    }

    public Stream<TupleTree> extractOutputsMapping(MappingTree document) {
        return this.extractMappingToTupleTreeOnField(document, "outputs");
    }

    public OutputDeclaration convertOutputDeclaration(TupleTree tree) {
        Identifier name = this.toIdentifier(tree.key());
        StringLiteral type = this.toStringLiteralOrException(tree, "type");
        StringLiteral condition = this.toStringLiteralOrNull(tree.value(), "condition");
        Expression value = this.toExpressionOrNull(tree, "value");
        StringLiteral copyCount = this.toNestedStringLiteralOrNull(tree.value(), "copy", "count");
        StringLiteral copyInput = this.toNestedStringLiteralOrNull(tree.value(), "copy", "input");
        return new OutputDeclarationImpl(name, type, condition, copyCount, copyInput, value);
    }
}

