/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks.utils;

import java.util.function.Predicate;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.BooleanLiteral;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.common.checks.TextUtils;

public class CheckUtils {
    private CheckUtils() {
    }

    public static Predicate<Expression> isValue(Predicate<String> predicate) {
        return expr -> TextUtils.matchesValue(expr, predicate).isTrue();
    }

    public static Predicate<Expression> isEqual(String targetString) {
        return expr -> TextUtils.matchesValue(expr, targetString::equals).isTrue();
    }

    public static Predicate<Expression> contains(String targetString) {
        return expr -> TextUtils.matchesValue(expr, str -> str.contains(targetString)).isTrue();
    }

    public static Predicate<Expression> isFalse() {
        return expr -> expr.is(ArmTree.Kind.BOOLEAN_LITERAL) && !((BooleanLiteral)expr).value();
    }
}

