/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.common.api.checks.SecondaryLocation;

@Rule(key="S6387")
public class SubscriptionRoleAssignmentCheck
extends AbstractArmResourceCheck {
    private static final String MESSAGE = "Make sure assigning this role with a %s is safe here.";
    private static final Map<File.Scope, String> SENSITIVE_SCOPE_WITH_NAME = Map.of(File.Scope.SUBSCRIPTION, "Subscription scope", File.Scope.MANAGEMENT_GROUP, "Management Group scope");

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Authorization/roleAssignments", SubscriptionRoleAssignmentCheck::checkRoleAssignments);
    }

    private static void checkRoleAssignments(ContextualResource resource) {
        String sensitiveScope;
        File file = (File)((ResourceDeclaration)resource.tree).parent();
        if (file != null && (sensitiveScope = SENSITIVE_SCOPE_WITH_NAME.get((Object)file.targetScope())) != null) {
            resource.report(String.format(MESSAGE, sensitiveScope), new SecondaryLocation(file.targetScopeLiteral(), sensitiveScope));
        }
    }
}

