/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.yaml.TreePredicates;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.kubernetes.checks.AbstractKubernetesObjectCheck;

@Rule(key="S6430")
public class PrivilegeEscalationCheck
extends AbstractKubernetesObjectCheck {
    private static final String MESSAGE = "Make sure that enabling privilege escalation is safe here.";
    private static final String PRIVILEGE_ESCALATION_ATTRIBUTE = "allowPrivilegeEscalation";

    @Override
    void registerObjectCheck() {
        this.register("Pod", (BlockObject pod) -> pod.blocks("containers").forEach(container -> container.block("securityContext").attribute(PRIVILEGE_ESCALATION_ATTRIBUTE).reportIfValue(TreePredicates.isTrue(), MESSAGE)));
        this.register(List.of("DaemonSet", "Deployment", "Job", "ReplicaSet", "ReplicationController", "StatefulSet"), (BlockObject obj) -> obj.block("template").block("spec").blocks("containers").forEach(container -> container.block("securityContext").attribute(PRIVILEGE_ESCALATION_ATTRIBUTE).reportIfValue(TreePredicates.isTrue(), MESSAGE)));
    }
}

