/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.plugin;

import java.util.List;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.IacSensor;
import org.sonar.iac.common.extension.visitors.ChecksVisitor;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.docker.checks.DockerCheckList;
import org.sonar.iac.docker.parser.DockerParser;
import org.sonar.iac.docker.plugin.DockerLanguage;
import org.sonar.iac.docker.visitors.DockerHighlightingVisitor;
import org.sonar.iac.docker.visitors.DockerMetricsVisitor;

@Phase(name=Phase.Name.POST)
public class DockerSensor
extends IacSensor {
    private final Checks<IacCheck> checks;

    protected DockerSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, DockerLanguage language) {
        super(sonarRuntime, fileLinesContextFactory, noSonarFilter, (Language)language);
        this.checks = checkFactory.create("docker");
        this.checks.addAnnotatedChecks(DockerCheckList.checks());
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.processesFilesIndependently().name("IaC " + this.language.getName() + " Sensor");
    }

    @Override
    protected FilePredicate mainFilePredicate(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        FilePredicates p = fileSystem.predicates();
        return p.and(p.or(p.matchesPathPattern("**/Dockerfile"), p.matchesPathPattern("**/Dockerfile.*")), p.hasType(InputFile.Type.MAIN));
    }

    protected DockerParser treeParser() {
        return new DockerParser();
    }

    @Override
    protected String repositoryKey() {
        return "docker";
    }

    @Override
    protected List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        return List.of(new ChecksVisitor(this.checks, statistics), new DockerMetricsVisitor(this.fileLinesContextFactory, this.noSonarFilter), new DockerHighlightingVisitor());
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.docker.activate";
    }
}

