/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.yaml.TreePredicates;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.kubernetes.checks.AbstractKubernetesObjectCheck;

@Rule(key="S6433")
public class MountingFileSystemPathsCheck
extends AbstractKubernetesObjectCheck {
    private static final String MESSAGE = "Make sure mounting the file system path is safe here.";
    private static final List<String> SENSITIVE_PATHS = List.of("/bin", "/boot", "/etc", "/home", "/root", "/sbin", "/usr", "/var");
    private static final String HOST_PATH = "hostPath";

    @Override
    void registerObjectCheck() {
        this.register("Pod", (BlockObject pod) -> pod.blocks("volumes").forEach(container -> container.block(HOST_PATH).attribute("path").reportIfValue(TreePredicates.startsWith(SENSITIVE_PATHS), MESSAGE)));
        this.register("PersistentVolume", (BlockObject perVolu) -> perVolu.block(HOST_PATH).attribute("path").reportIfValue(TreePredicates.startsWith(SENSITIVE_PATHS), MESSAGE));
        this.register(List.of("DaemonSet", "Deployment", "Job", "ReplicaSet", "ReplicationController", "StatefulSet"), (BlockObject obj) -> obj.block("template").block("spec").blocks("volumes").forEach(container -> container.block(HOST_PATH).attribute("path").reportIfValue(TreePredicates.startsWith(SENSITIVE_PATHS), MESSAGE)));
    }
}

