/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

public abstract class AbstractKubernetesObjectCheck
implements IacCheck {
    private final Map<String, List<Consumer<BlockObject>>> objectConsumersByKind = new HashMap<String, List<Consumer<BlockObject>>>();

    public void initialize(InitContext init) {
        init.register(FileTree.class, (ctx, fileTree) -> fileTree.documents().stream().filter(MappingTree.class::isInstance).forEach(documentTree -> this.visitDocument((MappingTree)documentTree, (CheckContext)ctx)));
        this.registerObjectCheck();
    }

    private void visitDocument(MappingTree documentTree, CheckContext ctx) {
        PropertyUtils.get((Tree)documentTree, (String)"kind").flatMap(kind -> TextUtils.getValue((Tree)kind.value())).filter(this.objectConsumersByKind::containsKey).ifPresent(kind -> PropertyUtils.get((Tree)documentTree, (String)"spec").filter(TupleTree.class::isInstance).map(TupleTree.class::cast).filter(t -> t.value() instanceof MappingTree).ifPresent(spec -> {
            BlockObject obj = BlockObject.fromPresent((CheckContext)ctx, (YamlTree)spec.value(), (String)kind);
            this.objectConsumersByKind.get(kind).forEach(consumer -> consumer.accept(obj));
        }));
    }

    abstract void registerObjectCheck();

    protected void register(String kind, Consumer<BlockObject> consumer) {
        this.objectConsumersByKind.computeIfAbsent(kind, s -> new ArrayList()).add(consumer);
    }

    protected void register(Iterable<String> kinds, Consumer<BlockObject> consumer) {
        kinds.forEach(kind -> this.register((String)kind, consumer));
    }
}

