/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.plugin;

import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;

public class DockerSettings {
    static final String FILE_PATTERNS_KEY = "sonar.docker.file.patterns";
    static final String DEFAULT_FILE_PATTERNS = "Dockerfile,*.dockerfile";
    static final String HADOLINT_REPORTS_KEY = "sonar.docker.hadolint.reportPaths";
    static final String ACTIVATION_KEY = "sonar.docker.activate";
    static final String ACTIVATION_DEFAULT_VALUE = "true";
    private static final String DOCKER_CATEGORY = "Docker";
    private static final String GENERAL_SUBCATEGORY = "General";
    private static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";

    private DockerSettings() {
    }

    public static List<PropertyDefinition> getGeneralProperties() {
        return List.of(PropertyDefinition.builder((String)ACTIVATION_KEY).index(1).defaultValue(ACTIVATION_DEFAULT_VALUE).name("Activate Docker Analysis").description("Disabling Docker analysis ensures that no Docker files are parsed, highlighted and analyzed, and no IaC analysis results are included in the quality gate.").type(PropertyType.BOOLEAN).onQualifiers("TRK", new String[0]).category(DOCKER_CATEGORY).subCategory(GENERAL_SUBCATEGORY).build(), PropertyDefinition.builder((String)FILE_PATTERNS_KEY).defaultValue(DEFAULT_FILE_PATTERNS).name("File Patterns").description("List of file patterns of Docker files to be indexed. Details on the expected format can be found on the 'Docker' documentation page.").onQualifiers("TRK", new String[0]).category(DOCKER_CATEGORY).multiValues(true).subCategory(GENERAL_SUBCATEGORY).build());
    }

    public static List<PropertyDefinition> getExternalReportProperties() {
        return List.of(PropertyDefinition.builder((String)HADOLINT_REPORTS_KEY).index(33).name("Hadolint Report Files").description("Paths (absolute or relative) to the files with Hadolint issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(DOCKER_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build());
    }
}

