/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.parser;

import com.sonar.sslr.api.typed.Input;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.impl.CommentImpl;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;

public class DockerPreprocessor {
    private static final String NOT_EOL_CHARS = "[^\\n\\r\\u2028\\u2029]";
    private static final String COMMENT = "(#[^\\n\\r\\u2028\\u2029]*+)";
    private static final String INLINE_COMMENT_OR_EMPTY_LINE = "(?<![^\\n\\r\\u2028\\u2029])(?<inlineCommentOrEmptyLine>(?:[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+(#[^\\n\\r\\u2028\\u2029]*+)?(?:(?:\\r\\n|[\\n\\r\\u2028\\u2029])|$))*)";
    private static final String COMMENT_LINE = "(?<![^\\n\\r\\u2028\\u2029])(?<commentLine>(?:[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+(#[^\\n\\r\\u2028\\u2029]*+)(?:(?:\\r\\n|[\\n\\r\\u2028\\u2029])|$)))";
    static final String DEFAULT_ESCAPE_CHAR = "\\\\";
    static final String ALTERNATIVE_ESCAPE_CHAR = "`";
    private static final String ALTERNATIVE_ESCAPE_CHAR_DIRECTIVE = "#\\s*+escape\\s*+=\\s*+`";
    private static final Pattern ALTERNATIVE_ESCAPE_CHAR_PATTERN = Pattern.compile("^(#[^(?:\\r\\n|[\\n\\r\\u2028\\u2029])]*+(?:\\r\\n|[\\n\\r\\u2028\\u2029])|\\s)*#\\s*+escape\\s*+=\\s*+`");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("(#[^\\n\\r\\u2028\\u2029]*+)");
    private static final Set<String> COMMENT_TYPES = Set.of("commentLine", "inlineCommentOrEmptyLine");

    public PreprocessorResult process(String source) {
        Input input = new Input(source.toCharArray());
        TreeMap<Integer, Integer> shiftedOffsetMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Comment> comments = new TreeMap<Integer, Comment>();
        StringBuilder sb = new StringBuilder(source);
        int shiftedIndex = 0;
        Matcher m = DockerPreprocessor.matchRemovableSequences(source);
        while (m.find()) {
            int startIndex = m.start() - shiftedIndex;
            int removableLength = m.end() - m.start();
            sb.delete(startIndex, startIndex + removableLength);
            COMMENT_TYPES.forEach(type -> DockerPreprocessor.extractComments(input, m, comments, type));
            shiftedOffsetMap.put(m.end() - (shiftedIndex += removableLength), shiftedIndex);
        }
        SourceOffset sourceOffset = new SourceOffset(input, shiftedOffsetMap);
        return new PreprocessorResult(sb.toString(), sourceOffset, comments);
    }

    private static void extractComments(Input input, Matcher sourceMatcher, SortedMap<Integer, Comment> commentMap, String commentType) {
        String commentLine = sourceMatcher.group(commentType);
        if (commentLine != null) {
            Matcher commentMatcher = COMMENT_PATTERN.matcher(commentLine);
            while (commentMatcher.find()) {
                int[] lineAndColumn = input.lineAndColumnAt(sourceMatcher.start(commentType) + commentMatcher.start());
                Comment comment = DockerPreprocessor.buildComment(commentMatcher.group(), lineAndColumn[0], lineAndColumn[1] - 1);
                commentMap.put(lineAndColumn[0], comment);
            }
        }
    }

    private static Comment buildComment(String value, int line, int column) {
        TextRange range = TextRanges.range((int)line, (int)column, (String)value);
        String contentText = value.length() > 1 ? value.substring(1).trim() : "";
        return new CommentImpl(value, contentText, range);
    }

    private static Matcher matchRemovableSequences(String source) {
        String escapeCharacter = DockerPreprocessor.determineEscapeCharacter(source);
        String escapedLineBreaks = "(?<escapedLineBreaks>(?<!escape=)" + escapeCharacter + "[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+(?:\\r\\n|[\\n\\r\\u2028\\u2029]))";
        String multiLineInstruction = escapedLineBreaks + INLINE_COMMENT_OR_EMPTY_LINE;
        String pattern = "(?:" + multiLineInstruction + "|(?<![^\\n\\r\\u2028\\u2029])(?<commentLine>(?:[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+(#[^\\n\\r\\u2028\\u2029]*+)(?:(?:\\r\\n|[\\n\\r\\u2028\\u2029])|$))))";
        return Pattern.compile(pattern).matcher(source);
    }

    static String determineEscapeCharacter(String source) {
        return ALTERNATIVE_ESCAPE_CHAR_PATTERN.matcher(source).find() ? ALTERNATIVE_ESCAPE_CHAR : DEFAULT_ESCAPE_CHAR;
    }

    static class PreprocessorResult {
        private final String processedSourceCode;
        private final SourceOffset sourceOffset;
        private final SortedMap<Integer, Comment> commentMap;

        public PreprocessorResult(String processedSourceCode, SourceOffset sourceOffset, SortedMap<Integer, Comment> commentMap) {
            this.processedSourceCode = processedSourceCode;
            this.sourceOffset = sourceOffset;
            this.commentMap = commentMap;
        }

        public String processedSourceCode() {
            return this.processedSourceCode;
        }

        public SourceOffset sourceOffset() {
            return this.sourceOffset;
        }

        public SortedMap<Integer, Comment> commentMap() {
            return this.commentMap;
        }
    }

    public static class SourceOffset {
        protected final Input input;
        protected final Iterator<Map.Entry<Integer, Integer>> shiftedOffsetIterator;
        private int currentOffsetAdjustment = 0;
        private int nextOffsetAdjustment = 0;
        private int nextIndexOffset = 0;

        public SourceOffset(Input input, SortedMap<Integer, Integer> shiftedOffsetMap) {
            this.input = input;
            this.shiftedOffsetIterator = shiftedOffsetMap.entrySet().iterator();
            if (this.shiftedOffsetIterator.hasNext()) {
                this.moveToNextOffset();
            }
        }

        public int[] sourceLineAndColumnAt(int index) {
            return this.input.lineAndColumnAt(this.adjustIndex(index));
        }

        public int adjustIndex(int index) {
            while (this.nextIndexOffset <= index) {
                this.currentOffsetAdjustment = this.nextOffsetAdjustment;
                if (!this.shiftedOffsetIterator.hasNext()) break;
                this.moveToNextOffset();
            }
            return index + this.currentOffsetAdjustment;
        }

        private void moveToNextOffset() {
            Map.Entry<Integer, Integer> nextOffset = this.shiftedOffsetIterator.next();
            this.nextIndexOffset = nextOffset.getKey();
            this.nextOffsetAdjustment = nextOffset.getValue();
        }
    }
}

