/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils.command;

import java.util.function.Predicate;
import org.sonar.iac.docker.checks.utils.command.CommandPredicate;
import org.sonar.iac.docker.checks.utils.command.PredicateContext;
import org.sonar.iac.docker.symbols.ArgumentResolution;

public class IncludingUnresolvedArgumentsArgumentResolutionPredicate
implements CommandPredicate {
    private final Predicate<ArgumentResolution> predicate;

    public IncludingUnresolvedArgumentsArgumentResolutionPredicate(Predicate<ArgumentResolution> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean hasType(CommandPredicate.Type ... types) {
        for (CommandPredicate.Type t : types) {
            if (CommandPredicate.Type.MATCH != t) continue;
            return true;
        }
        return false;
    }

    @Override
    public void match(PredicateContext context) {
        ArgumentResolution resolution = context.getNextArgumentToHandleAndRemoveFromList();
        if (!this.predicate.test(resolution)) {
            context.setStatus(PredicateContext.Status.FOUND_NO_PREDICATE_MATCH);
            return;
        }
        context.addAsArgumentToReport(resolution);
        context.setStatus(PredicateContext.Status.CONTINUE);
    }

    @Override
    public boolean continueOnUnresolved() {
        return true;
    }
}

