/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.checks.utils.command.SeparatedList;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.impl.ArgumentImpl;
import org.sonar.iac.docker.tree.impl.LiteralImpl;
import org.sonar.iac.docker.tree.impl.SyntaxTokenImpl;

public final class ArgumentResolutionSplitter {
    private static final String STRING_IN_DOUBLE_QUOTES = "\"(?:\\\\.|[^\"])*+\"";
    private static final String STRING_IN_SIMPLE_QUOTES = "'(?:\\\\.|[^'])*+'";
    private static final String NON_SEPARATOR_CHARACTER = "[^;&|]";
    private static final String COMMAND_WITHOUT_OPERATOR = "(?:\"(?:\\\\.|[^\"])*+\"|'(?:\\\\.|[^'])*+'|[^;&|])*+";
    private static final String OPERATORS = "(?:;|&&|&|\\|\\||\\|)";
    private static final String FIRST_COMMAND = "firstCommand";
    private static final String REMAINDER = "remainder";
    private static final Pattern FIRST_COMMAND_AND_REST_REGEX = Pattern.compile("^(?<firstCommand>(?:\"(?:\\\\.|[^\"])*+\"|'(?:\\\\.|[^'])*+'|[^;&|])*+)(?<remainder>(?:(?:;|&&|&|\\|\\||\\|)(?:\"(?:\\\\.|[^\"])*+\"|'(?:\\\\.|[^'])*+'|[^;&|])*+)++)$");
    private static final String OPERATOR = "operator";
    private static final String COMMAND = "command";
    private static final Pattern OPERATOR_AND_COMMAND_REGEX = Pattern.compile("(?<operator>(?:;|&&|&|\\|\\||\\|))(?<command>(?:\"(?:\\\\.|[^\"])*+\"|'(?:\\\\.|[^'])*+'|[^;&|])*+)");

    private ArgumentResolutionSplitter() {
    }

    public static SeparatedList<List<ArgumentResolution>, String> splitCommands(Iterable<ArgumentResolution> resolvedArguments) {
        CommandDetector.SeparatedListBuilder separatedListBuilder = new CommandDetector.SeparatedListBuilder();
        for (ArgumentResolution resolvedArgument : resolvedArguments) {
            ArgumentResolutionSplitter.parseCommand(separatedListBuilder, resolvedArgument);
        }
        return separatedListBuilder.build();
    }

    private static void parseCommand(CommandDetector.SeparatedListBuilder separatedListBuilder, ArgumentResolution resolvedArgument) {
        String argument = resolvedArgument.value();
        Matcher fullMatcher = FIRST_COMMAND_AND_REST_REGEX.matcher(argument);
        if (fullMatcher.find()) {
            String firstCommand = fullMatcher.group(FIRST_COMMAND);
            String remainder = fullMatcher.group(REMAINDER);
            if (!firstCommand.isBlank()) {
                ArgumentResolution newResolvedArg = ArgumentResolutionSplitter.buildSubArgument(resolvedArgument, firstCommand, 0);
                separatedListBuilder.addToCurrentCommand(newResolvedArg);
            }
            ArgumentResolutionSplitter.parseRemainderOfTheCommand(separatedListBuilder, resolvedArgument, fullMatcher, remainder);
        } else {
            separatedListBuilder.addToCurrentCommand(resolvedArgument);
        }
    }

    private static void parseRemainderOfTheCommand(CommandDetector.SeparatedListBuilder separatedListBuilder, ArgumentResolution resolvedArgument, Matcher fullMatcher, String remainder) {
        Matcher matcher = OPERATOR_AND_COMMAND_REGEX.matcher(remainder);
        while (matcher.find()) {
            String operator = matcher.group(OPERATOR);
            String command = matcher.group(COMMAND);
            separatedListBuilder.addOperator(operator);
            if (command.isBlank()) continue;
            ArgumentResolution newResolvedArg = ArgumentResolutionSplitter.buildSubArgument(resolvedArgument, command, fullMatcher.start(REMAINDER) + matcher.start(COMMAND));
            separatedListBuilder.addToCurrentCommand(newResolvedArg);
        }
    }

    private static ArgumentResolution buildSubArgument(ArgumentResolution resolvedArgument, String firstCommand, int offsetShift) {
        TextRange argumentRange = resolvedArgument.argument().textRange();
        SyntaxTokenImpl token = new SyntaxTokenImpl(firstCommand, TextRanges.range((int)argumentRange.start().line(), (int)(argumentRange.start().lineOffset() + offsetShift), (String)firstCommand), Collections.emptyList());
        LiteralImpl literal = new LiteralImpl(token);
        token.setParent(literal);
        ArgumentImpl newArg = new ArgumentImpl(List.of(literal));
        literal.setParent(newArg);
        newArg.setParent(resolvedArgument.argument().parent());
        return ArgumentResolution.ofWithoutStrippingQuotes(newArg);
    }
}

