/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.tree.api.Argument;
import org.sonar.iac.docker.tree.api.CmdInstruction;
import org.sonar.iac.docker.tree.api.CommandInstruction;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.EntrypointInstruction;
import org.sonar.iac.docker.tree.api.Expression;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6570")
public class VariableReferenceOutsideOfQuotesCheck
implements IacCheck {
    private static final String MESSAGE = "Surround this variable with double quotes; otherwise, it can lead to unexpected behavior.";

    public void initialize(InitContext init) {
        init.register(RunInstruction.class, VariableReferenceOutsideOfQuotesCheck::checkVariableReference);
        init.register(CmdInstruction.class, VariableReferenceOutsideOfQuotesCheck::checkVariableReference);
        init.register(EntrypointInstruction.class, VariableReferenceOutsideOfQuotesCheck::checkVariableReference);
    }

    private static void checkVariableReference(CheckContext ctx, CommandInstruction commandInstruction) {
        for (Argument argument : commandInstruction.arguments()) {
            for (Expression expression : argument.expressions()) {
                if (!expression.is(DockerTree.Kind.REGULAR_VARIABLE)) continue;
                ctx.reportIssue((HasTextRange)expression, MESSAGE);
            }
        }
    }
}

