/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.Alias;
import org.sonar.iac.docker.tree.api.Body;
import org.sonar.iac.docker.tree.api.DockerImage;
import org.sonar.iac.docker.tree.api.FromInstruction;

@Rule(key="S6596")
public class SpecificVersionTagCheck
implements IacCheck {
    private static final String MESSAGE = "Use a specific version tag for the image.";

    public void initialize(InitContext init) {
        init.register(Body.class, SpecificVersionTagCheck::checkBody);
    }

    private static void checkBody(CheckContext ctx, Body body) {
        HashSet<String> encounteredAlias = new HashSet<String>();
        for (DockerImage dockerImage : body.dockerImages()) {
            SpecificVersionTagCheck.checkFromInstruction(ctx, dockerImage.from(), encounteredAlias);
        }
    }

    private static void checkFromInstruction(CheckContext ctx, FromInstruction fromInstruction, Set<String> encounteredAlias) {
        Alias alias;
        ArgumentResolution resolvedImage = ArgumentResolution.of(fromInstruction.image());
        if (resolvedImage.isUnresolved()) {
            return;
        }
        String fullImageName = resolvedImage.value();
        if (SpecificVersionTagCheck.hasSensitiveVersionTag(fullImageName) && !encounteredAlias.contains(fullImageName)) {
            ctx.reportIssue(fromInstruction.image().textRange(), MESSAGE);
        }
        if ((alias = fromInstruction.alias()) != null) {
            encounteredAlias.add(alias.alias().value());
        }
    }

    private static boolean hasSensitiveVersionTag(String fullImageName) {
        if (fullImageName.contains("@")) {
            return false;
        }
        if (fullImageName.contains(":")) {
            String[] splitImageName = fullImageName.split(":");
            return splitImageName.length > 1 && "latest".equals(splitImageName[1]);
        }
        return true;
    }
}

