/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.checks.utils.ArgumentResolutionSplitter;
import org.sonar.iac.docker.checks.utils.CheckUtils;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.checks.utils.command.SeparatedList;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.CmdInstruction;
import org.sonar.iac.docker.tree.api.CommandInstruction;
import org.sonar.iac.docker.tree.api.EntrypointInstruction;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6573")
public class ShellExpansionsInCommandCheck
implements IacCheck {
    private static final String MESSAGE = "Prefix files and paths with ./ or -- when using glob.";
    private static final Set<String> exceptionCommands = Set.of("echo", "printf");
    private static final Set<String> exceptionBashTokensBefore = Set.of("--", "for");

    public void initialize(InitContext init) {
        init.register(RunInstruction.class, CheckUtils.ignoringExecForm(ShellExpansionsInCommandCheck::check));
        init.register(CmdInstruction.class, CheckUtils.ignoringExecForm(ShellExpansionsInCommandCheck::check));
        init.register(EntrypointInstruction.class, CheckUtils.ignoringExecForm(ShellExpansionsInCommandCheck::check));
    }

    private static void check(CheckContext ctx, CommandInstruction cmd) {
        SeparatedList<List<ArgumentResolution>, String> splitCommands = ArgumentResolutionSplitter.splitCommands(CheckUtils.resolveInstructionArguments(cmd));
        CommandDetector shellExpansionDetector = CommandDetector.builder().with(ShellExpansionsInCommandCheck::isShellExpansion).build();
        for (List<ArgumentResolution> argumentResolutions : splitCommands.elements()) {
            shellExpansionDetector.search(argumentResolutions).forEach(c -> {
                List<ArgumentResolution> argumentResolutionsBeforeMatch = argumentResolutions.subList(0, argumentResolutions.indexOf(c.getResolvedArguments().get(0)));
                if (ShellExpansionsInCommandCheck.contains(argumentResolutionsBeforeMatch, exceptionBashTokensBefore) || ShellExpansionsInCommandCheck.isCompliantExceptionCommand(argumentResolutionsBeforeMatch)) {
                    return;
                }
                ctx.reportIssue(c.textRange(), MESSAGE);
            });
        }
    }

    private static boolean isShellExpansion(String arg) {
        return arg.startsWith("*") && !arg.contains(")");
    }

    private static boolean contains(List<ArgumentResolution> argumentResolutions, Collection<String> symbols) {
        for (ArgumentResolution argumentResolution : argumentResolutions) {
            for (String symbol : symbols) {
                if (!symbol.equals(argumentResolution.value())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCompliantExceptionCommand(List<ArgumentResolution> argumentResolutionsBeforeWildcard) {
        for (int i = argumentResolutionsBeforeWildcard.size() - 1; i >= 0; --i) {
            if (ShellExpansionsInCommandCheck.isFlag(argumentResolutionsBeforeWildcard.get(i))) {
                return false;
            }
            if (!exceptionCommands.contains(argumentResolutionsBeforeWildcard.get(i).value())) continue;
            return i != argumentResolutionsBeforeWildcard.size() - 1;
        }
        return false;
    }

    private static boolean isFlag(ArgumentResolution arg) {
        return arg.value().startsWith("-");
    }
}

