/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.docker.checks.utils.Chmod;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.Argument;
import org.sonar.iac.docker.tree.api.RunInstruction;
import org.sonar.iac.docker.tree.api.TransferInstruction;

@Rule(key="S2612")
public class PosixPermissionCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure granting write access to others is safe here.";

    public void initialize(InitContext init) {
        init.register(TransferInstruction.class, PosixPermissionCheck::checkTransferChmodPermission);
        init.register(RunInstruction.class, PosixPermissionCheck::checkRunChmodPermission);
    }

    private static void checkRunChmodPermission(CheckContext ctx, RunInstruction runInstruction) {
        for (Chmod chmod : Chmod.extractChmodsFromArguments(runInstruction.arguments())) {
            if (!chmod.hasPermission("o+w") && !chmod.hasPermission("g+s") && !chmod.hasPermission("u+s")) continue;
            TextRange textRange = TextRanges.merge(List.of(chmod.chmodArg.textRange(), chmod.permissionsArg.textRange()));
            ctx.reportIssue(textRange, MESSAGE);
        }
    }

    private static void checkTransferChmodPermission(CheckContext ctx, TransferInstruction transferInstruction) {
        transferInstruction.options().stream().filter(flag -> "chmod".equals(flag.name())).filter(flag -> PosixPermissionCheck.isPermissionSensitive(flag.value())).forEach(flag -> ctx.reportIssue((HasTextRange)flag, MESSAGE));
    }

    private static boolean isPermissionSensitive(@Nullable Argument permission) {
        if (permission == null) {
            return false;
        }
        String permissionString = ArgumentResolution.of(permission).value();
        if (permissionString == null) {
            return false;
        }
        return Chmod.Permission.fromNumeric(permissionString).hasRight("o+w");
    }
}

