/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.checks.utils.ArgumentResolutionSplitter;
import org.sonar.iac.docker.checks.utils.CheckUtils;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.checks.utils.command.SeparatedList;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6595")
public class PackageManagerUpdateWithoutInstallCheck
implements IacCheck {
    private static final String MESSAGE = "Update cache and install packages in single RUN instruction.";
    private static final Set<String> PACKAGE_MANAGERS = Set.of("apk", "apt", "apt-get", "aptitude");
    private static final CommandDetector PACKAGE_MANAGER_DETECTOR = CommandDetector.builder().with(PACKAGE_MANAGERS).withAnyIncludingUnresolvedRepeating(s -> true).build();
    private static final CommandDetector PACKAGE_MANAGER_UPDATE_DETECTOR = CommandDetector.builder().with(PACKAGE_MANAGERS).withAnyFlag().with("update").build();

    public void initialize(InitContext init) {
        init.register(RunInstruction.class, PackageManagerUpdateWithoutInstallCheck::checkPackageManagerInvocations);
    }

    private static void checkPackageManagerInvocations(CheckContext ctx, RunInstruction runInstruction) {
        SeparatedList<List<ArgumentResolution>, String> splitCommands = ArgumentResolutionSplitter.splitCommands(CheckUtils.resolveInstructionArguments(runInstruction));
        for (int i = 0; i < splitCommands.elements().size(); ++i) {
            List<ArgumentResolution> argumentResolutions = splitCommands.elements().get(i);
            for (CommandDetector.Command command : PACKAGE_MANAGER_UPDATE_DETECTOR.search(argumentResolutions)) {
                List<List<ArgumentResolution>> commandsAfterMatch = splitCommands.elements().subList(i + 1, splitCommands.elements().size());
                commandsAfterMatch.add(0, PackageManagerUpdateWithoutInstallCheck.subListAfter(argumentResolutions, command.getResolvedArguments()));
                boolean hasNoPackageManagerInvocation = commandsAfterMatch.stream().allMatch(resolutions -> PACKAGE_MANAGER_DETECTOR.search((List<ArgumentResolution>)resolutions).isEmpty());
                if (!hasNoPackageManagerInvocation) continue;
                ctx.reportIssue(command.textRange(), MESSAGE);
            }
        }
    }

    private static List<ArgumentResolution> subListAfter(List<ArgumentResolution> original, List<ArgumentResolution> part) {
        return original.subList(original.indexOf(part.get(part.size() - 1)) + 1, original.size());
    }
}

