/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.Argument;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6431")
public class HostNetworkNamespaceCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure it is safe to use the host operating system namespace here.";

    public void initialize(InitContext init) {
        init.register(RunInstruction.class, HostNetworkNamespaceCheck::checkHostNetwork);
    }

    private static void checkHostNetwork(CheckContext ctx, RunInstruction runInstruction) {
        runInstruction.options().stream().filter(flag -> "network".equals(flag.name()) && HostNetworkNamespaceCheck.isArgValue(flag.value(), "host")).forEach(flag -> ctx.reportIssue((HasTextRange)flag, MESSAGE));
    }

    private static boolean isArgValue(@Nullable Argument argument, String expectedValue) {
        return argument != null && expectedValue.equals(ArgumentResolution.of(argument).value());
    }
}

