/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.checks.utils.CheckUtils;
import org.sonar.iac.docker.checks.utils.Chmod;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.Argument;
import org.sonar.iac.docker.tree.api.Flag;
import org.sonar.iac.docker.tree.api.TransferInstruction;

@Rule(key="S6504")
public class ExecutableNotOwnedByRootCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure no write permissions are assigned to the executable.";
    private static final String MESSAGE_SECONDARY_OTHER_EXEC = "Other executable file.";
    private static final String MESSAGE_SECONDARY_CHOWN = "Sensitive file owner.";
    private static final Set<String> SENSITIVE_FILE_EXTENSION = Set.of("exe", "py", "rb", "pl", "lua", "js", "lisp", "sh", "jar", "war", "run", "bin", "bat", "ps1");
    private static final Set<String> COMPLIANT_CHOWN_VALUES = Set.of("root", "0", "");

    public void initialize(InitContext init) {
        init.register(TransferInstruction.class, ExecutableNotOwnedByRootCheck::checkTransferInstruction);
    }

    private static void checkTransferInstruction(CheckContext ctx, TransferInstruction transferInstruction) {
        Flag sensitiveChownFlag = ExecutableNotOwnedByRootCheck.getSensitiveChownFlag(transferInstruction);
        if (sensitiveChownFlag != null) {
            Chmod chmod;
            List<Argument> sensitiveFiles = ExecutableNotOwnedByRootCheck.getSensitiveFiles(transferInstruction.srcs());
            if (ExecutableNotOwnedByRootCheck.isNonRootUser(sensitiveChownFlag)) {
                ExecutableNotOwnedByRootCheck.reportIssue(ctx, sensitiveChownFlag, sensitiveFiles);
            }
            if ((chmod = ExecutableNotOwnedByRootCheck.getChmod(transferInstruction)) == null) {
                if (!sensitiveFiles.isEmpty()) {
                    ExecutableNotOwnedByRootCheck.reportIssue(ctx, sensitiveChownFlag, sensitiveFiles);
                }
            } else if (ExecutableNotOwnedByRootCheck.isSensitiveChmod(sensitiveChownFlag, sensitiveFiles, chmod)) {
                ExecutableNotOwnedByRootCheck.reportIssue(ctx, sensitiveChownFlag, sensitiveFiles);
            }
        }
    }

    private static boolean isSensitiveChmod(Flag sensitiveChownFlag, List<Argument> sensitiveFiles, Chmod chmod) {
        return !ExecutableNotOwnedByRootCheck.isRootUserAndGroupHasNoWritePermission(sensitiveChownFlag, chmod) && ExecutableNotOwnedByRootCheck.isSensitiveWriteChmod(chmod) && (ExecutableNotOwnedByRootCheck.isSensitiveExecuteChmod(chmod) || !sensitiveFiles.isEmpty());
    }

    private static void reportIssue(CheckContext ctx, Flag sensitiveChownFlag, List<Argument> sensitiveFiles) {
        if (sensitiveFiles.isEmpty()) {
            ctx.reportIssue((HasTextRange)sensitiveChownFlag, MESSAGE);
        } else {
            HasTextRange primaryLocation = (HasTextRange)sensitiveFiles.get(0);
            ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
            for (Argument otherExecutable : sensitiveFiles.subList(1, sensitiveFiles.size())) {
                secondaryLocations.add(new SecondaryLocation((HasTextRange)otherExecutable, MESSAGE_SECONDARY_OTHER_EXEC));
            }
            secondaryLocations.add(new SecondaryLocation((HasTextRange)sensitiveChownFlag, MESSAGE_SECONDARY_CHOWN));
            ctx.reportIssue(primaryLocation, MESSAGE, secondaryLocations);
        }
    }

    @CheckForNull
    private static Flag getSensitiveChownFlag(TransferInstruction transferInstruction) {
        return transferInstruction.options().stream().filter(f -> f.name().equals("chown")).filter(ExecutableNotOwnedByRootCheck::isSensitiveUser).findFirst().orElse(null);
    }

    private static boolean isSensitiveUser(Flag chownFlag) {
        ArgumentResolution resolvedArgArgument = ArgumentResolution.of(chownFlag.value());
        return resolvedArgArgument.isResolved() && ExecutableNotOwnedByRootCheck.isNonRootChown(resolvedArgArgument.value());
    }

    @CheckForNull
    private static Chmod getChmod(TransferInstruction transferInstruction) {
        return transferInstruction.options().stream().filter(f -> f.name().equals("chmod")).map(f -> ArgumentResolution.of(f.value())).filter(ArgumentResolution::isResolved).map(argResolved -> new Chmod(null, null, argResolved.value())).findFirst().orElse(null);
    }

    private static List<Argument> getSensitiveFiles(List<Argument> arguments) {
        return arguments.stream().map(ArgumentResolution::of).filter(ExecutableNotOwnedByRootCheck::isSensitiveFile).map(ArgumentResolution::argument).collect(Collectors.toList());
    }

    private static boolean isSensitiveFile(ArgumentResolution argumentResolution) {
        return argumentResolution.isResolved() && SENSITIVE_FILE_EXTENSION.contains(CheckUtils.getFileExtension(argumentResolution.value()));
    }

    private static boolean isSensitiveWriteChmod(Chmod chmod) {
        return chmod.hasPermission("u+w") || chmod.hasPermission("g+w");
    }

    private static boolean isSensitiveExecuteChmod(Chmod chmod) {
        return chmod.hasPermission("u+x") || chmod.hasPermission("g+x") || chmod.hasPermission("o+x");
    }

    private static boolean isRootUserAndGroupHasNoWritePermission(Flag chown, Chmod chmod) {
        ArgumentResolution resolvedChown = ArgumentResolution.of(chown.value());
        boolean isRootUser = !ExecutableNotOwnedByRootCheck.isNonRootAtId(resolvedChown.value(), 0);
        return !chmod.hasPermission("g+w") && isRootUser && ExecutableNotOwnedByRootCheck.isNonRootAtId(resolvedChown.value(), 1);
    }

    private static boolean isNonRootUser(Flag sensitiveChownFlag) {
        ArgumentResolution resolvedChown = ArgumentResolution.of(sensitiveChownFlag.value());
        return ExecutableNotOwnedByRootCheck.isNonRootAtId(resolvedChown.value(), 0);
    }

    private static boolean isNonRootChown(String chownValue) {
        return ExecutableNotOwnedByRootCheck.isNonRootAtId(chownValue, 0) || ExecutableNotOwnedByRootCheck.isNonRootAtId(chownValue, 1);
    }

    static boolean isNonRootAtId(String chownValue, int indexToCheck) {
        String[] split = chownValue.split(":");
        if (split.length > indexToCheck) {
            return !COMPLIANT_CHOWN_VALUES.contains(split[indexToCheck]);
        }
        return false;
    }
}

