/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.EnvInstruction;
import org.sonar.iac.docker.tree.api.KeyValuePair;

@Rule(key="S4507")
public class DebugModeCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";
    private static final Pattern ENV_DEV_NAME_PATTERN = Pattern.compile("^([_A-Z]+)?ENV(IRONMENT)?$", 2);
    private static final Pattern ENV_DEV_VALUE_PATTERN = Pattern.compile("^dev(el(op(ment)?)?)?$", 2);
    private static final Pattern DEBUG_ENABLED_NAME_PATTERN = Pattern.compile("^([_A-Z]+)?DEBUG$", 2);
    private static final Pattern DEBUG_ENABLED_VALUE_PATTERN = Pattern.compile("^(true|yes|on|1)$", 2);
    private static final Pattern PHPX_DEBUG_ENABLED_NAME_PATTERN = Pattern.compile("^([_A-Z]+)?XDEBUG_MODE$", 2);

    public void initialize(InitContext init) {
        init.register(EnvInstruction.class, DebugModeCheck::checkEnvDebug);
    }

    private static void checkEnvDebug(CheckContext ctx, EnvInstruction envInstruction) {
        for (KeyValuePair variable : envInstruction.environmentVariables()) {
            String name = ArgumentResolution.of(variable.key()).value();
            String value = ArgumentResolution.of(variable.value()).value();
            if (name == null || value == null || !DebugModeCheck.isVariableSensitive(name, value)) continue;
            ctx.reportIssue((HasTextRange)variable, MESSAGE);
        }
    }

    private static boolean isVariableSensitive(String name, String value) {
        return DebugModeCheck.isDevEnv(name, value) || DebugModeCheck.isDebugMode(name, value) || DebugModeCheck.isPhpXDebugMode(name, value);
    }

    private static boolean isDevEnv(String name, String value) {
        return ENV_DEV_NAME_PATTERN.matcher(name).matches() && ENV_DEV_VALUE_PATTERN.matcher(value).matches();
    }

    private static boolean isDebugMode(String name, String value) {
        return DEBUG_ENABLED_NAME_PATTERN.matcher(name).matches() && DEBUG_ENABLED_VALUE_PATTERN.matcher(value).matches();
    }

    private static boolean isPhpXDebugMode(String name, String value) {
        return PHPX_DEBUG_ENABLED_NAME_PATTERN.matcher(name).matches() && !value.equalsIgnoreCase("off");
    }
}

