/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.Objects;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.symbols.Scope;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.Variable;

@Rule(key="S6579")
public class ArgDefinedOutsideOfScopeCheck
implements IacCheck {
    private static final String MESSAGE = "Include the ARG instruction in the build stage where it is used.";

    public void initialize(InitContext init) {
        init.register(Variable.class, ArgDefinedOutsideOfScopeCheck::checkVariableIsDefinedLocally);
    }

    private static void checkVariableIsDefinedLocally(CheckContext ctx, Variable variable) {
        if (variable.symbol() == null || Stream.iterate(variable, Objects::nonNull, DockerTree::parent).anyMatch(t -> t.is(DockerTree.Kind.FROM))) {
            return;
        }
        if (Scope.Kind.GLOBAL == variable.symbol().lastDeclarationScope()) {
            ctx.reportIssue(variable.textRange(), MESSAGE);
        }
    }
}

