/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.symbols.Scope;
import org.sonar.iac.docker.symbols.Symbol;
import org.sonar.iac.docker.symbols.Usage;
import org.sonar.iac.docker.tree.api.ArgInstruction;
import org.sonar.iac.docker.tree.api.Argument;
import org.sonar.iac.docker.tree.api.Body;
import org.sonar.iac.docker.tree.api.DockerImage;
import org.sonar.iac.docker.tree.api.EnvInstruction;
import org.sonar.iac.docker.tree.api.FromInstruction;
import org.sonar.iac.docker.tree.api.KeyValuePair;
import org.sonar.iac.docker.tree.api.Variable;

public class DockerSymbolVisitor
extends TreeVisitor<InputFileContext> {
    private final List<TreeVisitor.ConsumerFilter<InputFileContext, ?>> consumersAfter = new ArrayList();
    private final Scope globalScope;
    private Scope currentScope = this.globalScope = new Scope(Scope.Kind.GLOBAL);

    public DockerSymbolVisitor() {
        this.register(Body.class, this::setGlobalScope);
        this.register(FromInstruction.class, this::restoreGlobalScope);
        this.registerAfter(FromInstruction.class, this::setImageScope);
        this.register(ArgInstruction.class, (ctx, argInstruction) -> this.visitAssignmentInstruction(argInstruction.keyValuePairs()));
        this.register(EnvInstruction.class, (ctx, envInstruction) -> this.visitAssignmentInstruction(envInstruction.environmentVariables()));
        this.register(Variable.class, (ctx, variable) -> this.visitVariable((Variable)variable));
    }

    protected void visit(InputFileContext ctx, @Nullable Tree node) {
        if (node != null) {
            ctx.enter(node);
            DockerSymbolVisitor.callConsumers(ctx, node, this.consumers);
            node.children().forEach(child -> this.visit(ctx, (Tree)child));
            DockerSymbolVisitor.callConsumers(ctx, node, this.consumersAfter);
            ctx.leave();
        }
    }

    private static void callConsumers(InputFileContext ctx, Tree node, List<TreeVisitor.ConsumerFilter<InputFileContext, ?>> consumerList) {
        for (TreeVisitor.ConsumerFilter<InputFileContext, ?> consumer : consumerList) {
            consumer.accept((TreeContext)ctx, node);
        }
    }

    public <T extends Tree> TreeVisitor<InputFileContext> registerAfter(Class<T> cls, BiConsumer<InputFileContext, T> visitor) {
        this.consumersAfter.add(new TreeVisitor.ConsumerFilter(cls, visitor));
        return this;
    }

    public void setGlobalScope(InputFileContext ctx, Body body) {
        body.setScope(this.globalScope);
    }

    public void restoreGlobalScope(InputFileContext ctx, FromInstruction from) {
        this.currentScope = this.globalScope;
    }

    public void setImageScope(InputFileContext ctx, FromInstruction from) {
        DockerImage dockerImage = (DockerImage)from.parent();
        this.currentScope = new Scope(Scope.Kind.IMAGE, this.globalScope);
        dockerImage.setScope(this.currentScope);
    }

    private void visitAssignmentInstruction(List<KeyValuePair> assignments) {
        for (KeyValuePair keyValuePair : assignments) {
            Argument identifier = keyValuePair.key();
            this.visitPossibleVariablesInIdentifier(identifier);
            ArgumentResolution resolution = ArgumentResolution.of(identifier);
            if (!resolution.is(ArgumentResolution.Status.RESOLVED) || resolution.value().isBlank()) continue;
            Symbol symbol = this.currentScope.addSymbol(resolution.value());
            symbol.addUsage(this.currentScope, keyValuePair, Usage.Kind.ASSIGNMENT);
        }
    }

    private void visitPossibleVariablesInIdentifier(Argument identifier) {
        identifier.expressions().stream().filter(Variable.class::isInstance).map(Variable.class::cast).forEach(this::visitVariable);
    }

    private void visitVariable(Variable variable) {
        if (variable.symbol() != null) {
            return;
        }
        Symbol symbol = this.currentScope.getSymbol(variable.identifier());
        if (symbol != null) {
            symbol.addUsage(this.currentScope, variable, Usage.Kind.ACCESS);
        }
    }
}

