/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.symbols;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.iac.docker.symbols.Scope;
import org.sonar.iac.docker.symbols.Symbol;
import org.sonar.iac.docker.symbols.Usage;
import org.sonar.iac.docker.tree.api.Argument;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.EncapsulatedVariable;
import org.sonar.iac.docker.tree.api.ExpandableStringCharacters;
import org.sonar.iac.docker.tree.api.ExpandableStringLiteral;
import org.sonar.iac.docker.tree.api.Expression;
import org.sonar.iac.docker.tree.api.KeyValuePair;
import org.sonar.iac.docker.tree.api.Literal;
import org.sonar.iac.docker.tree.api.Variable;
import org.sonarsource.analyzer.commons.collections.ListUtils;

public class ArgumentResolution {
    static final ArgumentResolution EMPTY = new ArgumentResolution("", Status.EMPTY);
    private final String value;
    private final Status status;

    private ArgumentResolution(String value, Status status) {
        this.value = value;
        this.status = status;
    }

    public static ArgumentResolution of(@Nullable Argument argument) {
        return ArgumentResolver.resolve(argument);
    }

    public String value() {
        return this.value;
    }

    public Status status() {
        return this.status;
    }

    public boolean is(Status status) {
        return this.status == status;
    }

    private static class ArgumentResolver {
        Builder resolution = new Builder();
        Set<Variable> visitedVariable = new HashSet<Variable>();

        private ArgumentResolver() {
        }

        private static ArgumentResolution resolve(@Nullable Argument argument) {
            return new ArgumentResolver().resolveArgument(argument);
        }

        private ArgumentResolution resolveArgument(@Nullable Argument argument) {
            if (argument == null) {
                return EMPTY;
            }
            this.resolveExpressions(argument.expressions());
            return this.resolution.build();
        }

        private void resolveExpressions(List<Expression> expressions) {
            for (Expression expression : expressions) {
                this.resolveExpression(expression);
            }
        }

        private void resolveExpression(Expression expression) {
            switch (expression.getKind()) {
                case STRING_LITERAL: {
                    this.resolution.addValue(((Literal)expression).value());
                    break;
                }
                case EXPANDABLE_STRING_CHARACTERS: {
                    this.resolution.addValue(((ExpandableStringCharacters)expression).value());
                    break;
                }
                case EXPANDABLE_STRING_LITERAL: {
                    this.resolveExpressions(((ExpandableStringLiteral)expression).expressions());
                    break;
                }
                case REGULAR_VARIABLE: {
                    this.resolveVariable((Variable)expression);
                    break;
                }
                case ENCAPSULATED_VARIABLE: {
                    EncapsulatedVariable encapsulatedVariable = (EncapsulatedVariable)expression;
                    if (!":+".equals(encapsulatedVariable.modifierSeparator())) {
                        this.resolveVariable(encapsulatedVariable);
                        break;
                    }
                    this.resolution.setUnresolved();
                    break;
                }
            }
        }

        private void resolveVariable(Variable variable) {
            Scope.Kind accessScopeKind;
            Symbol symbol = variable.symbol();
            if (!this.visitedVariable.add(variable) || symbol == null) {
                this.resolution.setUnresolved();
                return;
            }
            List usages = ListUtils.reverse(symbol.usages());
            List<Usage> reversedAssignments = usages.stream().filter(usage -> usage.kind().equals((Object)Usage.Kind.ASSIGNMENT)).collect(Collectors.toList());
            Argument lastAssignedValue = ArgumentResolver.findLastAccessibleAssignedValue(reversedAssignments, accessScopeKind = ((Usage)usages.get(0)).scope().kind());
            if (lastAssignedValue != null) {
                this.resolveExpressions(lastAssignedValue.expressions());
            } else {
                this.resolution.setUnresolved();
            }
        }

        @Nullable
        private static Argument findLastAccessibleAssignedValue(List<Usage> assignments, Scope.Kind accessScopeKind) {
            boolean hasAccessToGlobalScope = false;
            for (Usage assignment : assignments) {
                if (!assignment.tree().is(DockerTree.Kind.KEY_VALUE_PAIR)) continue;
                KeyValuePair assignmentTree = (KeyValuePair)assignment.tree();
                Argument value = assignmentTree.value();
                if (value != null) {
                    return assignment.scope().kind().equals((Object)accessScopeKind) || hasAccessToGlobalScope ? value : null;
                }
                hasAccessToGlobalScope = true;
            }
            return null;
        }
    }

    private static class Builder {
        private Status status = Status.RESOLVED;
        private final StringBuilder sb = new StringBuilder();

        private Builder() {
        }

        private void addValue(String value) {
            this.sb.append(value);
        }

        private void setUnresolved() {
            this.status = Status.UNRESOLVED;
        }

        public ArgumentResolution build() {
            return new ArgumentResolution(this.sb.toString(), this.status);
        }
    }

    public static enum Status {
        RESOLVED,
        UNRESOLVED,
        EMPTY;

    }
}

