/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.plugin;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.IacSensor;
import org.sonar.iac.common.extension.visitors.ChecksVisitor;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.docker.checks.DockerCheckList;
import org.sonar.iac.docker.parser.DockerParser;
import org.sonar.iac.docker.plugin.DockerLanguage;
import org.sonar.iac.docker.visitors.DockerHighlightingVisitor;
import org.sonar.iac.docker.visitors.DockerMetricsVisitor;
import org.sonar.iac.docker.visitors.DockerSymbolVisitor;

@Phase(name=Phase.Name.POST)
public class DockerSensor
extends IacSensor {
    private final Checks<IacCheck> checks;

    public DockerSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, DockerLanguage language) {
        super(sonarRuntime, fileLinesContextFactory, noSonarFilter, (Language)language);
        this.checks = checkFactory.create("docker");
        this.checks.addAnnotatedChecks(DockerCheckList.checks());
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.processesFilesIndependently().name("IaC " + this.language.getName() + " Sensor");
    }

    protected FilePredicate mainFilePredicate(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        FilePredicates p = fileSystem.predicates();
        return p.and(p.or(new FilePredicate[]{p.matchesPathPattern("**/Dockerfile"), p.matchesPathPattern("**/Dockerfile.*"), p.matchesPathPattern("**/**.Dockerfile"), p.matchesPathPattern("**/**.dockerfile")}), p.hasType(InputFile.Type.MAIN));
    }

    protected DockerParser treeParser() {
        return DockerParser.create();
    }

    protected String repositoryKey() {
        return "docker";
    }

    protected List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        ArrayList<TreeVisitor<InputFileContext>> visitors = new ArrayList<TreeVisitor<InputFileContext>>();
        visitors.add(new DockerSymbolVisitor());
        visitors.add((TreeVisitor<InputFileContext>)new ChecksVisitor(this.checks, statistics));
        if (this.isNotSonarLintContext(sensorContext)) {
            visitors.add((TreeVisitor<InputFileContext>)new DockerMetricsVisitor(this.fileLinesContextFactory, this.noSonarFilter));
            visitors.add((TreeVisitor<InputFileContext>)new DockerHighlightingVisitor());
        }
        return visitors;
    }

    protected String getActivationSettingKey() {
        return "sonar.docker.activate";
    }
}

