/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.parser;

import com.sonar.sslr.api.typed.Input;
import org.sonar.iac.common.api.tree.impl.TextPointer;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.docker.parser.DockerNodeBuilder;
import org.sonar.iac.docker.parser.DockerParser;
import org.sonar.iac.docker.parser.grammar.DockerLexicalGrammar;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class DockerHeredocParser
extends DockerParser {
    private final DockerHeredocNodeBuilder heredocNodeBuilder;

    private DockerHeredocParser(DockerHeredocNodeBuilder heredocNodeBuilder, GrammarRuleKey rootRule) {
        super(heredocNodeBuilder, rootRule);
        this.heredocNodeBuilder = heredocNodeBuilder;
    }

    public static DockerHeredocParser create() {
        return new DockerHeredocParser(new DockerHeredocNodeBuilder(), (GrammarRuleKey)DockerLexicalGrammar.HEREDOC_FORM_CONTENT);
    }

    public DockerTree parse(String source, TextPointer offset) {
        this.heredocNodeBuilder.setOffset(offset);
        return super.parse(source);
    }

    static class DockerHeredocNodeBuilder
    extends DockerNodeBuilder {
        private TextPointer offset;

        DockerHeredocNodeBuilder() {
        }

        @Override
        protected TextRange tokenRange(Input input, int startIndex, String value) {
            TextRange textRange = super.tokenRange(input, startIndex, value);
            return this.shiftTextRange(textRange);
        }

        private TextRange shiftTextRange(TextRange textRange) {
            TextPointer start = textRange.start();
            TextPointer end = textRange.end();
            return TextRanges.range((int)(start.line() + this.offset.line() - 1), (int)(start.lineOffset() + (start.line() == 1 ? this.offset.lineOffset() : 0)), (int)(end.line() + this.offset.line() - 1), (int)(end.lineOffset() + (end.line() == 1 ? this.offset.lineOffset() : 0)));
        }

        protected void setOffset(TextPointer offset) {
            this.offset = offset;
        }
    }
}

