/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.Argument;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6500")
public class PackageInstallationCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure that installing unnecessary dependencies is safe here.";
    private static final Map<String, String> COMMAND_FLAG_MAP = Map.of("apt", "--no-install-recommends", "apt-get", "--no-install-recommends", "aptitude", "--without-recommends");

    public void initialize(InitContext init) {
        init.register(RunInstruction.class, PackageInstallationCheck::checkRunInstruction);
    }

    private static void checkRunInstruction(CheckContext ctx, RunInstruction instruction) {
        StatementValidator validator = new StatementValidator(ctx);
        instruction.arguments().forEach(validator::process);
    }

    private static class StatementValidator {
        CheckContext ctx;
        AptStatement statement;

        StatementValidator(CheckContext ctx) {
            this.ctx = ctx;
        }

        void process(Argument argument) {
            ArgumentResolution resolution = ArgumentResolution.of(argument);
            if (resolution.is(ArgumentResolution.Status.UNRESOLVED)) {
                this.statement = null;
                return;
            }
            String argValue = resolution.value();
            if (COMMAND_FLAG_MAP.containsKey(argValue)) {
                this.reportSensitiveStatement();
                this.statement = new AptStatement(argument, COMMAND_FLAG_MAP.get(argValue));
            } else if (this.statement != null) {
                if (argValue.startsWith("-")) {
                    if (this.statement.requiredFlag.equals(argValue)) {
                        this.statement = null;
                    } else {
                        this.statement.add(argument);
                    }
                } else if ("install".equals(argValue)) {
                    this.statement.isInstallStatement = true;
                    this.statement.add(argument);
                } else {
                    this.reportSensitiveStatement();
                }
            }
        }

        private void reportSensitiveStatement() {
            if (this.statement != null && this.statement.isInstallStatement) {
                this.ctx.reportIssue(StatementValidator.mergeArgumentTextRange(this.statement.arguments), PackageInstallationCheck.MESSAGE);
                this.statement = null;
            }
        }

        private static TextRange mergeArgumentTextRange(List<Argument> arguments) {
            ArrayList<TextRange> textRanges = new ArrayList<TextRange>();
            for (Argument argument : arguments) {
                textRanges.add(argument.textRange());
            }
            return TextRanges.merge(textRanges);
        }

        private static class AptStatement {
            List<Argument> arguments = new ArrayList<Argument>();
            boolean isInstallStatement = false;
            String requiredFlag;

            public AptStatement(Argument command, String requiredFlag) {
                this.arguments.add(command);
                this.requiredFlag = requiredFlag;
            }

            public void add(Argument element) {
                this.arguments.add(element);
            }
        }
    }
}

