/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.FromInstruction;

@Rule(key="S6497")
public class ImageWithDigestCheck
implements IacCheck {
    private static final String MESSAGE = "Setting a digest will prevent receiving updates of the base image. Make sure it is safe here.";

    public void initialize(InitContext init) {
        init.register(FromInstruction.class, ImageWithDigestCheck::checkFrom);
    }

    private static void checkFrom(CheckContext ctx, FromInstruction fromInstruction) {
        String image = ArgumentResolution.of(fromInstruction.image()).value();
        if (image != null && image.contains("@")) {
            ctx.reportIssue((HasTextRange)fromInstruction.image(), MESSAGE);
        }
    }
}

