/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.visitors;

import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.docker.symbols.Scope;
import org.sonar.iac.docker.symbols.Symbol;
import org.sonar.iac.docker.symbols.Usage;
import org.sonar.iac.docker.tree.api.ArgInstruction;
import org.sonar.iac.docker.tree.api.Body;
import org.sonar.iac.docker.tree.api.DockerImage;
import org.sonar.iac.docker.tree.api.KeyValuePair;
import org.sonar.iac.docker.tree.api.Variable;
import org.sonar.iac.docker.utils.ArgumentUtils;

public class DockerSymbolVisitor
extends TreeVisitor<InputFileContext> {
    private final Scope globalScope;
    private Scope currentScope;

    public DockerSymbolVisitor() {
        this.currentScope = this.globalScope = new Scope(Scope.Kind.GLOBAL);
        this.register(Body.class, this::setGlobalScope);
        this.register(DockerImage.class, this::setImageScope);
        this.register(ArgInstruction.class, this::visitArgInstruction);
        this.register(Variable.class, this::visitVariable);
    }

    public void setGlobalScope(InputFileContext ctx, Body body) {
        body.setScope(this.globalScope);
    }

    public void setImageScope(InputFileContext ctx, DockerImage dockerImage) {
        this.currentScope = new Scope(Scope.Kind.IMAGE, this.globalScope);
        dockerImage.setScope(this.currentScope);
    }

    public void visitArgInstruction(InputFileContext ctx, ArgInstruction argInstruction) {
        for (KeyValuePair keyValuePair : argInstruction.keyValuePairs()) {
            String identifier = ArgumentUtils.resolve(keyValuePair.key()).value();
            if (identifier == null) continue;
            Symbol symbol = this.currentScope.addSymbol(identifier);
            symbol.addUsage(this.currentScope, keyValuePair, Usage.Kind.ASSIGNMENT);
        }
    }

    private void visitVariable(InputFileContext ctx, Variable variable) {
        Symbol symbol = this.currentScope.getSymbol(variable.identifier());
        if (symbol != null) {
            symbol.addUsage(this.currentScope, variable, Usage.Kind.ACCESS);
        }
    }
}

