/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.iac.docker.symbols.Scope;
import org.sonar.iac.docker.symbols.Symbol;
import org.sonar.iac.docker.symbols.Usage;
import org.sonar.iac.docker.tree.api.Argument;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.EncapsulatedVariable;
import org.sonar.iac.docker.tree.api.ExpandableStringCharacters;
import org.sonar.iac.docker.tree.api.ExpandableStringLiteral;
import org.sonar.iac.docker.tree.api.Expression;
import org.sonar.iac.docker.tree.api.HasArguments;
import org.sonar.iac.docker.tree.api.KeyValuePair;
import org.sonar.iac.docker.tree.api.Literal;
import org.sonar.iac.docker.tree.api.Variable;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    public static ArgumentResolution resolveAndMerge(HasArguments hasArguments) {
        StringBuilder sb = new StringBuilder();
        for (Argument argument : hasArguments.arguments()) {
            ArgumentResolution resolved = ArgumentUtils.resolve(argument);
            sb.append(resolved.value);
        }
        return new ArgumentResolution(sb.toString());
    }

    public static ArgumentResolution resolve(@Nullable Argument argument) {
        return ArgumentResolver.resolve(argument);
    }

    public static class ArgumentResolution {
        static final ArgumentResolution EMPTY = new ArgumentResolution(null);
        private final String value;

        ArgumentResolution(@Nullable String value) {
            this.value = value;
        }

        @Nullable
        public String value() {
            return this.value;
        }
    }

    private static class ArgumentResolver {
        Set<Expression> visitedExpressions = new HashSet<Expression>();

        private ArgumentResolver() {
        }

        private static ArgumentResolution resolve(@Nullable Argument argument) {
            if (argument == null) {
                return ArgumentResolution.EMPTY;
            }
            return new ArgumentResolver().resolveExpressions(argument.expressions());
        }

        private ArgumentResolution resolveExpressions(List<Expression> expressions) {
            StringBuilder sb = new StringBuilder();
            for (Expression expression : expressions) {
                if (!this.visitedExpressions.add(expression)) {
                    return ArgumentResolution.EMPTY;
                }
                String expressionResolution = this.resolveExpression(expression);
                if (expressionResolution == null) {
                    return ArgumentResolution.EMPTY;
                }
                sb.append(expressionResolution);
            }
            return new ArgumentResolution(sb.toString());
        }

        @Nullable
        private String resolveExpression(Expression expression) {
            if (expression.is(DockerTree.Kind.STRING_LITERAL)) {
                return ((Literal)expression).value();
            }
            if (expression.is(DockerTree.Kind.EXPANDABLE_STRING_LITERAL)) {
                return this.resolveExpressions(((ExpandableStringLiteral)expression).expressions()).value();
            }
            if (expression.is(DockerTree.Kind.EXPANDABLE_STRING_CHARACTERS)) {
                return ((ExpandableStringCharacters)expression).value();
            }
            if (expression.is(DockerTree.Kind.REGULAR_VARIABLE) || expression.is(DockerTree.Kind.ENCAPSULATED_VARIABLE) && !":+".equals(((EncapsulatedVariable)expression).modifierSeparator())) {
                return this.resolveVariable((Variable)expression).value();
            }
            return null;
        }

        private ArgumentResolution resolveVariable(Variable variable) {
            Symbol symbol = variable.symbol();
            return symbol != null ? this.resolveSymbol(symbol) : ArgumentResolution.EMPTY;
        }

        private ArgumentResolution resolveSymbol(Symbol symbol) {
            List<Usage> usages = symbol.usages();
            Collections.reverse(usages);
            List<Usage> reversedAssignments = usages.stream().filter(usage -> usage.kind().equals((Object)Usage.Kind.ASSIGNMENT)).collect(Collectors.toList());
            Scope.Kind accessScopeKind = usages.get(0).scope().kind();
            Argument lastAssignedValue = ArgumentResolver.findLastAccessibleAssignedValue(reversedAssignments, accessScopeKind);
            return lastAssignedValue != null ? this.resolveExpressions(lastAssignedValue.expressions()) : ArgumentResolution.EMPTY;
        }

        @Nullable
        private static Argument findLastAccessibleAssignedValue(List<Usage> assignments, Scope.Kind accessScopeKind) {
            boolean hasAccessToGlobalScope = false;
            for (Usage assignment : assignments) {
                if (!assignment.tree().is(DockerTree.Kind.KEY_VALUE_PAIR)) continue;
                KeyValuePair assignmentTree = (KeyValuePair)assignment.tree();
                Argument value = assignmentTree.value();
                if (value != null) {
                    return assignment.scope().kind().equals((Object)accessScopeKind) || hasAccessToGlobalScope ? value : null;
                }
                hasAccessToGlobalScope = true;
            }
            return null;
        }
    }
}

