/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.symbols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.iac.docker.symbols.Symbol;

public class Scope {
    private final Map<String, Symbol> symbols = new HashMap<String, Symbol>();
    private final Kind kind;

    public Scope(Kind kind) {
        this.kind = kind;
    }

    public Scope(Kind kind, Scope orgScope) {
        this(kind);
        orgScope.symbols.forEach((name, symbol) -> this.symbols.put((String)name, new Symbol((Symbol)symbol)));
    }

    public Symbol addSymbol(String name) {
        return this.symbols.computeIfAbsent(name, s -> new Symbol(name));
    }

    @Nullable
    public Symbol getSymbol(String name) {
        return this.symbols.getOrDefault(name, null);
    }

    public List<Symbol> getSymbols() {
        return new ArrayList<Symbol>(this.symbols.values());
    }

    public Kind kind() {
        return this.kind;
    }

    public static enum Kind {
        GLOBAL,
        IMAGE;

    }
}

