/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.parser.grammar;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import java.util.Arrays;
import org.sonar.iac.common.parser.grammar.Punctuator;
import org.sonar.iac.docker.parser.grammar.DockerKeyword;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;

public enum DockerLexicalGrammar implements GrammarRuleKey
{
    FILE,
    BODY,
    DOCKERIMAGE,
    STRING_LITERAL,
    EQUALS_OPERATOR,
    EOF,
    WHITESPACE,
    SKIPPED_WHITESPACE,
    WHITESPACE_OR_LINE_BREAK,
    SPACING,
    EOL,
    INSTRUCTION,
    ONBUILD,
    FROM,
    MAINTAINER,
    STOPSIGNAL,
    WORKDIR,
    EXPOSE,
    LABEL,
    ENV,
    ARG,
    CMD,
    ENTRYPOINT,
    RUN,
    ADD,
    COPY,
    USER,
    VOLUME,
    SHELL,
    HEALTHCHECK,
    HEALTHCHECK_NONE,
    NONE,
    ARGUMENTS,
    PORT,
    KEY_ONLY,
    KEY_VALUE_PAIR_EQUALS,
    KEY_VALUE_PAIR_SINGLE,
    FLAG,
    FLAG_PREFIX,
    FLAG_NAME,
    ARG_NAME,
    EXEC_FORM,
    SHELL_FORM,
    SHELL_FORM_GENERIC,
    HEREDOC_FORM,
    ALIAS,
    ALIAS_AS,
    IMAGE_ALIAS,
    HEREDOC_EXPRESSION,
    QUOTED_STRING_LITERAL,
    UNQUOTED_STRING_LITERAL,
    UNQUOTED_KEY_LITERAL,
    ARGUMENT,
    ARGUMENT_GENERIC,
    REGULAR_STRING_LITERAL,
    EXPANDABLE_STRING_LITERAL,
    EXPANDABLE_STRING_LITERAL_GENERIC,
    STRING_WITH_ENCAPS_VAR_CHARACTERS,
    UNQUOTED_VARIABLE_MODIFIER,
    REGULAR_VAR_IDENTIFIER,
    REGULAR_VARIABLE,
    ENCAPSULATED_VARIABLE,
    ENCAPSULATED_VARIABLE_GENERIC,
    ENCAPS_VAR_MODIFIER_SEPARATOR,
    ENCAPS_VAR_MODIFIER_GENERIC,
    KEY_VALUE_PAIR;


    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        DockerLexicalGrammar.lexical(b);
        DockerLexicalGrammar.punctuators(b);
        DockerLexicalGrammar.keywords(b);
        return b;
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)Punctuator.EQU).is((Object)Punctuator.EQU.getValue()).skip();
        b.rule((GrammarRuleKey)Punctuator.COMMA).is(b.optional((Object)SKIPPED_WHITESPACE), new Object[]{Punctuator.COMMA.getValue()}).skip();
        b.rule((GrammarRuleKey)Punctuator.RBRACKET).is(b.optional((Object)SKIPPED_WHITESPACE), new Object[]{Punctuator.RBRACKET.getValue()}).skip();
        b.rule((GrammarRuleKey)Punctuator.LBRACKET).is((Object)SKIPPED_WHITESPACE, new Object[]{Punctuator.LBRACKET.getValue()}).skip();
        b.rule((GrammarRuleKey)Punctuator.DOUBLE_QUOTE).is((Object)Punctuator.DOUBLE_QUOTE.getValue());
        b.rule((GrammarRuleKey)Punctuator.DOLLAR).is((Object)Punctuator.DOLLAR.getValue()).skip();
        b.rule((GrammarRuleKey)Punctuator.DOLLAR_LCURLY).is((Object)Punctuator.DOLLAR_LCURLY.getValue());
        b.rule((GrammarRuleKey)Punctuator.RCURLYBRACE).is((Object)Punctuator.RCURLYBRACE.getValue());
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)WHITESPACE).is(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++")).skip();
        b.rule((GrammarRuleKey)SKIPPED_WHITESPACE).is(b.skippedTrivia((Object)WHITESPACE));
        b.rule((GrammarRuleKey)WHITESPACE_OR_LINE_BREAK).is(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}\\n\\r\\u2028\\u2029]++")).skip();
        b.rule((GrammarRuleKey)EOL).is(b.regexp("(?:(?:\\r\\n|[\\n\\r\\u2028\\u2029])|$)"));
        b.rule((GrammarRuleKey)SPACING).is(b.oneOrMore(b.firstOf(b.commentTrivia(b.regexp("(?:#(?:[^\\n\\r])*+)")), b.skippedTrivia((Object)WHITESPACE_OR_LINE_BREAK)))).skip();
        b.rule((GrammarRuleKey)EOF).is(b.token((TokenType)GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule((GrammarRuleKey)REGULAR_VAR_IDENTIFIER).is(b.regexp("[a-zA-Z_0-9]++"));
        b.rule((GrammarRuleKey)ENCAPS_VAR_MODIFIER_SEPARATOR).is(b.regexp(":(-|\\+)"));
        b.rule((GrammarRuleKey)ENCAPS_VAR_MODIFIER_GENERIC).is(b.regexp("(\\\\}|[^}])+"));
        b.rule((GrammarRuleKey)QUOTED_STRING_LITERAL).is(b.regexp("(?:\"(?:(?:(?:[^\"\\\\$]|(?<!$)\\{)|(?:\\$(?!\\{|[a-zA-Z_0-9]))|(?:\\\\[\\s\\S]?))++)?+\"|'(?:[^'\\\\]*+(?:\\\\[\\s\\S])?+)*+')"));
        b.rule((GrammarRuleKey)UNQUOTED_STRING_LITERAL).is(b.regexp("(?:(?:\\\\$|\\\\'|\\\\\"|[^\\s'\"\\$]|\\$(?![a-zA-Z_0-9{]))++)"));
        b.rule((GrammarRuleKey)UNQUOTED_KEY_LITERAL).is(b.regexp("(?:(?:\\\\$|\\\\'|\\\\\"|[^\\s'\"$=])++)"));
        b.rule((GrammarRuleKey)STRING_WITH_ENCAPS_VAR_CHARACTERS).is(b.regexp("(?:(?:(?:[^\"\\\\$]|(?<!$)\\{)|(?:\\$(?!\\{|[a-zA-Z_0-9]))|(?:\\\\[\\s\\S]?))++)"));
        b.rule((GrammarRuleKey)UNQUOTED_VARIABLE_MODIFIER).is(b.regexp("(?:(?:\\\\$|\\\\'|\\\\\"|[^\\s'\"$}])++(?<!}))"));
        b.rule((GrammarRuleKey)STRING_LITERAL).is((Object)SKIPPED_WHITESPACE, new Object[]{b.regexp("(?:(?:\"(?:[^\"\\\\]*+(?:\\\\[\\s\\S])?+)*+\")|(?:(?:(?!(?:\\\\[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+(?:\\r\\n|[\\n\\r\\u2028\\u2029])))[^\\s])++))+")});
        b.rule((GrammarRuleKey)EQUALS_OPERATOR).is(b.regexp("="));
        b.rule((GrammarRuleKey)IMAGE_ALIAS).is((Object)SKIPPED_WHITESPACE, new Object[]{b.regexp("[-a-zA-Z0-9_\\.]+")});
        b.rule((GrammarRuleKey)FLAG_PREFIX).is((Object)SKIPPED_WHITESPACE, new Object[]{b.regexp("--")});
        b.rule((GrammarRuleKey)FLAG_NAME).is(b.regexp("[a-z][-a-z]*+"));
        b.rule((GrammarRuleKey)ALIAS_AS).is((Object)SKIPPED_WHITESPACE, new Object[]{b.regexp("(?i)AS")});
        b.rule((GrammarRuleKey)HEALTHCHECK_NONE).is((Object)SKIPPED_WHITESPACE, new Object[]{b.regexp("(?i)NONE")});
        b.rule((GrammarRuleKey)HEREDOC_EXPRESSION).is((Object)SKIPPED_WHITESPACE, new Object[]{b.regexp("(?:<<-?\"?([a-zA-Z_][a-zA-Z0-9_]*+)\"?\\s+)+[\\s\\S]*?([\\n\\r])\\1(?=[\\n\\r]|$)")});
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        Arrays.stream(DockerKeyword.values()).forEach(tokenType -> b.rule((GrammarRuleKey)tokenType).is(b.optional((Object)SPACING), new Object[]{b.regexp("(?i)" + tokenType.getValue())}).skip());
    }
}

