/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.parser;

import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import com.sonar.sslr.api.typed.NodeBuilder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.docker.parser.DockerNodeBuilder;
import org.sonar.iac.docker.parser.DockerPreprocessor;
import org.sonar.iac.docker.parser.TreeFactory;
import org.sonar.iac.docker.parser.grammar.DockerGrammar;
import org.sonar.iac.docker.parser.grammar.DockerLexicalGrammar;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class DockerParser
extends ActionParser<DockerTree>
implements TreeParser<Tree> {
    private final DockerPreprocessor preprocessor = new DockerPreprocessor();
    private final DockerNodeBuilder nodeBuilder;

    private DockerParser(DockerNodeBuilder nodeBuilder, GrammarRuleKey rootRule) {
        super(StandardCharsets.UTF_8, DockerLexicalGrammar.createGrammarBuilder(), DockerGrammar.class, (Object)new TreeFactory(), (NodeBuilder)nodeBuilder, rootRule);
        this.nodeBuilder = nodeBuilder;
    }

    public static DockerParser create() {
        return DockerParser.create(DockerLexicalGrammar.FILE);
    }

    public static DockerParser create(GrammarRuleKey rootRule) {
        return new DockerParser(new DockerNodeBuilder(), rootRule);
    }

    public DockerTree parse(String source) {
        DockerPreprocessor.PreprocessorResult preprocessorResult = this.preprocessor.process(source);
        this.nodeBuilder.setPreprocessorResult(preprocessorResult);
        try {
            DockerTree tree = (DockerTree)super.parse(preprocessorResult.processedSourceCode());
            DockerParser.setParents(tree);
            return tree;
        }
        catch (RecognitionException e) {
            throw RecognitionExceptionAdjuster.adjustLineAndColumnNumber(e, preprocessorResult.processedSourceCode(), preprocessorResult.sourceOffset());
        }
    }

    public Tree parse(String source, @Nullable InputFileContext inputFileContext) {
        return this.parse(source);
    }

    private static void setParents(DockerTree tree) {
        for (Tree children : tree.children()) {
            DockerTree child = (DockerTree)children;
            child.setParent(tree);
            DockerParser.setParents(child);
        }
    }

    static class RecognitionExceptionAdjuster {
        private static final String PARSING_ERROR_MESSAGE = "Parse error at line %d column %d %s";
        private static final Pattern RECOGNITION_EXCEPTION_LINE_COLUMN_PATTERN = Pattern.compile("Parse error at line (?<line>\\d+) column (?<column>\\d+)(?<rest>.*)");

        private RecognitionExceptionAdjuster() {
        }

        public static RecognitionException adjustLineAndColumnNumber(RecognitionException originalException, String sourceCode, DockerPreprocessor.SourceOffset sourceOffset) {
            Matcher m = RECOGNITION_EXCEPTION_LINE_COLUMN_PATTERN.matcher(originalException.getMessage());
            if (m.find()) {
                int line = Integer.parseInt(m.group("line"));
                int column = Integer.parseInt(m.group("column"));
                String rest = m.group("rest");
                int index = RecognitionExceptionAdjuster.computeIndexFromLineAndColumn(sourceCode, line, column);
                int[] correctedLineAndColumn = sourceOffset.sourceLineAndColumnAt(index);
                String newErrorMessage = String.format(PARSING_ERROR_MESSAGE, correctedLineAndColumn[0], correctedLineAndColumn[1], rest);
                return new RecognitionException(correctedLineAndColumn[0], newErrorMessage, originalException.getCause());
            }
            return originalException;
        }

        private static int computeIndexFromLineAndColumn(String code, int line, int column) {
            char[] chars = code.toCharArray();
            int currentLine = 1;
            int currentColumn = 0;
            int index = -1;
            while (index + 1 < chars.length && (line != currentLine || column != currentColumn)) {
                if (RecognitionExceptionAdjuster.isNewLine(chars, ++index)) {
                    ++currentLine;
                    currentColumn = 0;
                    continue;
                }
                ++currentColumn;
            }
            return index;
        }

        private static boolean isNewLine(char[] input, int i) {
            return input[i] == '\n' || input[i] == '\r' && (i + 1 == input.length || input[i + 1] != '\n');
        }
    }
}

