/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.parser;

import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.api.typed.Input;
import com.sonar.sslr.api.typed.NodeBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.docker.parser.DockerPreprocessor;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.impl.AbstractDockerTreeImpl;
import org.sonar.iac.docker.tree.impl.SyntaxTokenImpl;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class DockerNodeBuilder
implements NodeBuilder {
    public static final char BYTE_ORDER_MARK = '\ufeff';
    private DockerPreprocessor.SourceOffset sourceOffset;
    private Iterator<Map.Entry<Integer, Comment>> commentMapIterator;
    @Nullable
    private Map.Entry<Integer, Comment> nextComment;

    public Object createNonTerminal(GrammarRuleKey ruleKey, Rule rule, List<Object> children, int startIndex, int endIndex) {
        for (Object child : children) {
            if (!(child instanceof SyntaxTokenImpl)) continue;
            return child;
        }
        return new AbstractDockerTreeImpl(){

            public List<Tree> children() {
                throw new UnsupportedOperationException();
            }

            @Override
            public DockerTree.Kind getKind() {
                return DockerTree.Kind.TOKEN;
            }
        };
    }

    public Object createTerminal(Input input, int startIndex, int endIndex, List<Trivia> trivias, TokenType type) {
        String value = input.substring(startIndex, endIndex);
        TextRange range = this.tokenRange(input, startIndex, value);
        return new SyntaxTokenImpl(value, range, this.getCommentsForToken(range));
    }

    private TextRange tokenRange(Input input, int startIndex, String value) {
        int[] startLineAndColumn = this.sourceOffset.sourceLineAndColumnAt(startIndex);
        int[] endLineAndColumn = this.sourceOffset.sourceLineAndColumnAt(startIndex + value.length());
        char[] fileChars = input.input();
        boolean hasByteOrderMark = fileChars.length > 0 && fileChars[0] == '\ufeff';
        int startColumn = DockerNodeBuilder.applyByteOrderMark(startLineAndColumn[1], hasByteOrderMark);
        int endColum = DockerNodeBuilder.applyByteOrderMark(endLineAndColumn[1], hasByteOrderMark);
        return TextRanges.range((int)startLineAndColumn[0], (int)startColumn, (int)endLineAndColumn[0], (int)endColum);
    }

    private static int applyByteOrderMark(int column, boolean hasByteOrderMark) {
        return (hasByteOrderMark ? column - 1 : column) - 1;
    }

    List<Comment> getCommentsForToken(TextRange tokenRange) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        while (this.nextComment != null && DockerNodeBuilder.isAllocatableComment(this.nextComment.getKey(), tokenRange)) {
            comments.add(this.nextComment.getValue());
            this.nextComment = this.commentMapIterator.hasNext() ? this.commentMapIterator.next() : null;
        }
        return comments;
    }

    private static boolean isAllocatableComment(int commentLine, TextRange tokenRange) {
        return commentLine < tokenRange.end().line();
    }

    public void setPreprocessorResult(DockerPreprocessor.PreprocessorResult preprocessorResult) {
        this.sourceOffset = preprocessorResult.sourceOffset();
        this.commentMapIterator = preprocessorResult.commentMap().entrySet().iterator();
        if (this.commentMapIterator.hasNext()) {
            this.nextComment = this.commentMapIterator.next();
        }
    }
}

