/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.tree;

import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.docker.tree.api.DockerTree;

public class TreeUtils {
    private TreeUtils() {
    }

    public static Optional<Tree> getLastDescendant(Tree tree, Predicate<Tree> predicate) {
        DockerTree last = null;
        for (Tree child : tree.children()) {
            Optional<Tree> result;
            DockerTree dockerChild = (DockerTree)child;
            if (predicate.test(dockerChild)) {
                last = dockerChild;
            }
            if (!(result = TreeUtils.getLastDescendant(dockerChild, predicate)).isPresent()) continue;
            last = result.get();
        }
        return Optional.ofNullable(last);
    }
}

