/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.parser;

import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.api.typed.Input;
import com.sonar.sslr.api.typed.NodeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.CommentImpl;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.impl.DockerTreeImpl;
import org.sonar.iac.docker.tree.impl.SyntaxTokenImpl;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class DockerNodeBuilder
implements NodeBuilder {
    public static final char BYTE_ORDER_MARK = '\ufeff';

    public Object createNonTerminal(GrammarRuleKey ruleKey, Rule rule, List<Object> children, int startIndex, int endIndex) {
        for (Object child : children) {
            if (!(child instanceof SyntaxTokenImpl)) continue;
            return child;
        }
        return new DockerTreeImpl(){

            public List<Tree> children() {
                throw new UnsupportedOperationException();
            }

            @Override
            public DockerTree.Kind getKind() {
                return DockerTree.Kind.TOKEN;
            }
        };
    }

    public Object createTerminal(Input input, int startIndex, int endIndex, List<Trivia> trivias, TokenType type) {
        String value = input.substring(startIndex, endIndex);
        TextRange range = DockerNodeBuilder.tokenRange(input, startIndex, value);
        return new SyntaxTokenImpl(value, range, DockerNodeBuilder.createComments(trivias));
    }

    private static TextRange tokenRange(Input input, int startIndex, String value) {
        int[] lineAndColumn = input.lineAndColumnAt(startIndex);
        char[] fileChars = input.input();
        boolean hasByteOrderMark = fileChars.length > 0 && fileChars[0] == '\ufeff';
        int column = DockerNodeBuilder.applyByteOrderMark(lineAndColumn[1], hasByteOrderMark) - 1;
        return TextRanges.range((int)lineAndColumn[0], (int)column, (String)value);
    }

    private static int applyByteOrderMark(int column, boolean hasByteOrderMark) {
        return hasByteOrderMark ? column - 1 : column;
    }

    private static List<Comment> createComments(List<Trivia> trivias) {
        ArrayList<Comment> result = new ArrayList<Comment>();
        for (Trivia trivia : trivias) {
            Token triviaToken = trivia.getToken();
            String text = triviaToken.getValue();
            TextRange range = TextRanges.range((int)triviaToken.getLine(), (int)triviaToken.getColumn(), (String)text);
            result.add((Comment)new CommentImpl(text, text.substring(2), range));
        }
        return result;
    }
}

