/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.tree.api.AddTree;
import org.sonar.iac.docker.tree.api.CommandInstructionTree;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.LiteralListTree;
import org.sonar.iac.docker.tree.api.SyntaxToken;

@Rule(key="S5332")
public class UnencryptedProtocolCheck
implements IacCheck {
    private static final Pattern UNENCRYPTED_PROTOCOLS = Pattern.compile("(http|ftp)://(?<rest>.+)", 2);
    private static final String LOOPBACK_IPV4 = "^127(?:\\.\\d+){2}\\.\\d+";
    private static final String LOOPBACK_IPV6 = "^(?:0*:){7}:?0*1|^::1";
    private static final Pattern LOOPBACK = Pattern.compile("^localhost|^127(?:\\.\\d+){2}\\.\\d+|^(?:0*:){7}:?0*1|^::1", 2);
    private static final String MESSAGE = "Make sure that using clear-text protocols is safe here.";

    public void initialize(InitContext init) {
        init.register(CommandInstructionTree.class, (ctx, commandInstruction) -> {
            LiteralListTree arguments = commandInstruction.arguments();
            if (arguments == null || !commandInstruction.is(DockerTree.Kind.ADD, DockerTree.Kind.ENTRYPOINT, DockerTree.Kind.CMD, DockerTree.Kind.RUN)) {
                return;
            }
            UnencryptedProtocolCheck.checkUnencryptedProtocols(ctx, arguments.literals());
        });
        init.register(AddTree.class, (ctx, add) -> {
            UnencryptedProtocolCheck.checkUnencryptedProtocols(ctx, add.srcs());
            UnencryptedProtocolCheck.checkUnencryptedProtocols(ctx, List.of(add.dest()));
        });
    }

    private static void checkUnencryptedProtocols(CheckContext ctx, List<SyntaxToken> syntaxTokens) {
        for (SyntaxToken syntaxToken : syntaxTokens) {
            Matcher matcher = UNENCRYPTED_PROTOCOLS.matcher(syntaxToken.value());
            if (!matcher.find() || LOOPBACK.matcher(matcher.group("rest")).find()) continue;
            ctx.reportIssue((HasTextRange)syntaxToken, MESSAGE);
        }
    }
}

